/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.inspections.unescapedEl;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Objects;

public class SafeTagInfo {
    public String namespace;
    public String tagName;
    public String attributeName;
    public boolean fix;

    public SafeTagInfo() {
    }

    public SafeTagInfo(String namespace, String tagName, String attributeName, boolean fix) {
        this.namespace = namespace;
        this.tagName = tagName;
        this.attributeName = attributeName;
        this.fix = fix;
    }

    public SafeTagInfo(String namespace, String tagName, String attributeName) {
        this(namespace, tagName, attributeName, false);
    }

    public boolean matchAttribute(XmlAttribute attribute) {
        if (!this.attributeName.isEmpty() && !attribute.getLocalName().equals(this.attributeName)) {
            return false;
        }
        XmlTag tag = attribute.getParent();
        if (!this.tagName.isEmpty() && !tag.getLocalName().equals(this.tagName)) {
            return false;
        }
        return tag.getNamespace().equals(this.namespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SafeTagInfo info = (SafeTagInfo)o;
        if (this.fix != info.fix) {
            return false;
        }
        if (!Objects.equals(this.attributeName, info.attributeName)) {
            return false;
        }
        if (!Objects.equals(this.namespace, info.namespace)) {
            return false;
        }
        return Objects.equals(this.tagName, info.tagName);
    }
}

