/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.model;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;

public final class JpaPersistenceObjectDeleteHandler
extends JamDeleteHandler {
    public void addPsiElements(CommonModelElement element, Collection<? super PsiElement> result) {
        if (element instanceof PersistentObject) {
            PsiClass psiClass = (PsiClass)((PersistentObject)element).getClazz().getValue();
            Module module = psiClass == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            ContainerUtil.addIfNotNull(result, (Object)psiClass);
            if (module != null) {
                for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies(module)) {
                    for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
                        for (GenericValue<PsiClass> genericValue : persistencePackage.getModelHelper().getClasses()) {
                            if (!psiClass.equals(genericValue.getValue()) || !(genericValue instanceof GenericDomValue)) continue;
                            ContainerUtil.addIfNotNull(result, (Object)((GenericDomValue)genericValue).getXmlTag());
                        }
                    }
                }
            }
        }
    }

    public void addModelElements(CommonModelElement element, Collection<CommonModelElement> result) {
        Module module;
        PersistentObject persistentObject;
        block12: {
            block11: {
                if (!(element instanceof PersistentObject)) break block11;
                persistentObject = (PersistentObject)element;
                if (element.isValid()) break block12;
            }
            return;
        }
        PsiClass clazz = (PsiClass)persistentObject.getClazz().getValue();
        Module module2 = module = clazz == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        if (module == null) {
            return;
        }
        Processor processor = object -> !clazz.getManager().areElementsEquivalent((PsiElement)clazz, (PsiElement)object.getClazz().getValue());
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies(module)) {
            for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
                PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser(facet, persistencePackage, null);
                PersistenceMappings mappings = facet.getEntityMappings(persistencePackage);
                for (PersistentObject object2 : PersistenceCommonUtil.queryPersistentObjects(mappings).asIterable()) {
                    if (!processor.process((Object)object2)) {
                        result.add(object2);
                        continue;
                    }
                    for (PersistentAttribute attribute : browser.queryAttributes(object2).asIterable()) {
                        Query<PersistentObject> query;
                        if (attribute instanceof PersistentEmbeddedAttribute) {
                            query = browser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)attribute);
                        } else {
                            if (!(attribute instanceof PersistentRelationshipAttribute)) continue;
                            query = browser.queryTargetPersistentObjects((PersistentRelationshipAttribute)attribute);
                        }
                        if (query.forEach(processor)) continue;
                        result.add(attribute);
                    }
                }
            }
        }
    }
}

