/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.MongoDBJsonTokenSetsKt;
import com.intellij.persistence.mongodb.json.editor.MongoDBJsonTypedHandlerKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/persistence/mongodb/json/MongoDBJsonQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/MultiCharQuoteHandler;", "<init>", "()V", "getClosingQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "insertClosingQuote", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "closingQuote", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public MongoDBJsonQuoteHandler() {
        super(MongoDBJsonTokenSetsKt.getSTRING_LITERALS());
    }

    @NotNull
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        int index;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == TokenType.WHITE_SPACE && (index = iterator.getStart() - 1) >= 0) {
            return String.valueOf(iterator.getDocument().getCharsSequence().charAt(index));
        }
        return tokenType == MongoDBJsonElementTypes.SINGLE_QUOTED_STRING ? (CharSequence)"'" : (CharSequence)"\"";
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull PsiFile file, @NotNull CharSequence closingQuote) {
        PsiElement parent;
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)closingQuote, (String)"closingQuote");
        PsiElement psiElement = element = file.findElementAt(offset - 1);
        Object object = parent = psiElement != null ? psiElement.getParent() : null;
        if (parent instanceof MongoDBJsonStringLiteral) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            TextRange range = ((MongoDBJsonStringLiteral)parent).getTextRange();
            if (offset - 1 != range.getStartOffset() || !"\"".contentEquals(closingQuote)) {
                int endOffset = range.getEndOffset();
                if (offset < endOffset) {
                    return;
                }
                if (offset == endOffset && !StringUtil.isEmpty((String)((MongoDBJsonStringLiteral)parent).getValue())) {
                    return;
                }
            }
        }
        editor.getDocument().insertString(offset, closingQuote);
        MongoDBJsonTypedHandlerKt.processMongoPairedBracesComma(closingQuote.charAt(0), editor, file);
    }
}

