/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0017J$\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00192\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0004J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u0017H\u0014J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011J \u0010$\u001a\u0004\u0018\u00010\u00112\b\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0017H\u0014J0\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/intellij/javascript/debugger/NameMapper;", "", "document", "Lcom/intellij/openapi/editor/Document;", "transpiledDocument", "sourceMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/debugger/sourcemap/Mappings;Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getSourceMap", "()Lorg/jetbrains/debugger/sourcemap/SourceMap;", "value", "", "", "rawNameToSource", "getRawNameToSource", "()Ljava/util/Map;", "map", "identifierOrNamedElement", "Lcom/intellij/psi/PsiElement;", "saveMapping", "", "doMap", "mapBySourceCode", "getMappingsForElement", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "element", "addMapping", "", "generatedName", "sourceName", "extractName", "rawGeneratedName", "", "context", "getGeneratedName", "mappings", "Companion", "intellij.javascript.debugger.ui"})
public class NameMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final Document transpiledDocument;
    @NotNull
    private final Mappings sourceMappings;
    @NotNull
    private final SourceMap sourceMap;
    @Nullable
    private final VirtualFile transpiledFile;
    @Nullable
    private Map<String, String> rawNameToSource;

    public NameMapper(@NotNull Document document, @NotNull Document transpiledDocument, @NotNull Mappings sourceMappings, @NotNull SourceMap sourceMap, @Nullable VirtualFile transpiledFile) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)transpiledDocument, (String)"transpiledDocument");
        Intrinsics.checkNotNullParameter((Object)sourceMappings, (String)"sourceMappings");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        this.document = document;
        this.transpiledDocument = transpiledDocument;
        this.sourceMappings = sourceMappings;
        this.sourceMap = sourceMap;
        this.transpiledFile = transpiledFile;
    }

    public /* synthetic */ NameMapper(Document document, Document document2, Mappings mappings, SourceMap sourceMap, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            virtualFile = null;
        }
        this(document, document2, mappings, sourceMap, virtualFile);
    }

    @NotNull
    protected final SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Nullable
    public final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    @JvmOverloads
    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement, boolean saveMapping) {
        Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        return this.doMap(identifierOrNamedElement, false, saveMapping);
    }

    public static /* synthetic */ String map$default(NameMapper nameMapper, PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: map");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return nameMapper.map(psiElement, bl);
    }

    @Nullable
    protected final String doMap(@NotNull PsiElement identifierOrNamedElement, boolean mapBySourceCode, boolean saveMapping) {
        Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        List<MappingEntry> mappings = this.getMappingsForElement(identifierOrNamedElement);
        Collection collection = mappings;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        MappingEntry sourceEntry = mappings.get(0);
        String generatedName = null;
        try {
            generatedName = this.extractName(this.getGeneratedName(identifierOrNamedElement, this.transpiledDocument, this.sourceMap, mappings), identifierOrNamedElement);
        }
        catch (IndexOutOfBoundsException e) {
            VirtualFile virtualFile = this.transpiledFile;
            NameMapperKt.access$getLOG$p().warn("Cannot get generated name: source entry (" + sourceEntry.getGeneratedLine() + ",  " + sourceEntry.getGeneratedColumn() + "). Transpiled File: " + (virtualFile != null ? virtualFile.getPath() : null));
            return null;
        }
        CharSequence e = generatedName;
        if (e == null || e.length() == 0) {
            return null;
        }
        String sourceName = sourceEntry.getName();
        if (sourceName == null || mapBySourceCode) {
            Object object = identifierOrNamedElement instanceof PsiNamedElement ? (PsiNamedElement)identifierOrNamedElement : null;
            if ((object == null || (object = object.getName()) == null) && (object = identifierOrNamedElement.getText()) == null && (object = sourceName) == null) {
                return null;
            }
            sourceName = object;
        }
        if (saveMapping) {
            this.addMapping(generatedName, sourceName);
        }
        return generatedName;
    }

    public static /* synthetic */ String doMap$default(NameMapper nameMapper, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doMap");
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return nameMapper.doMap(psiElement, bl, bl2);
    }

    @Nullable
    protected List<MappingEntry> getMappingsForElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List mappings = new ArrayList();
        int offset = element.getTextOffset();
        int line = this.document.getLineNumber(offset);
        int elementColumn = offset - this.document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        int sourceEntryIndex = this.sourceMappings.indexOf(line, elementColumn);
        if (sourceEntryIndex == -1) {
            return null;
        }
        MappingEntry sourceEntry = this.sourceMappings.getByIndex(sourceEntryIndex);
        MappingEntry next = this.sourceMappings.getNextOnTheSameLine(sourceEntryIndex, false);
        if (next != null && this.sourceMappings.getColumn(next) == this.sourceMappings.getColumn(sourceEntry)) {
            NameMapperKt.warnSeveralMapping(element);
            return null;
        }
        PsiFile file = element.getContainingFile();
        AtomicInteger namedElementsCounter = new AtomicInteger(0);
        MappingsProcessorInLine processor2 = new MappingsProcessorInLine(elementColumn, elementEndColumn, this, line, mappings, file, namedElementsCounter){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ NameMapper this$0;
            final /* synthetic */ int $line;
            final /* synthetic */ List<MappingEntry> $mappings;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ AtomicInteger $namedElementsCounter;
            {
                this.$elementColumn = $elementColumn;
                this.$elementEndColumn = $elementEndColumn;
                this.this$0 = $receiver;
                this.$line = $line;
                this.$mappings = $mappings;
                this.$file = $file;
                this.$namedElementsCounter = $namedElementsCounter;
            }

            public boolean process(MappingEntry entry, MappingEntry nextEntry) {
                boolean isSuitable;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : (this.$elementColumn <= entryColumn ? entryColumn <= this.$elementEndColumn : (isSuitable = false));
                if (isSuitable) {
                    int endOffset;
                    int startOffset = NameMapper.access$getDocument$p(this.this$0).getLineStartOffset(this.$line) + entryColumn;
                    int n = endOffset = nextEntry != null ? NameMapper.access$getDocument$p(this.this$0).getLineStartOffset(this.$line) + nextEntry.getSourceColumn() : NameMapper.access$getDocument$p(this.this$0).getLineEndOffset(this.$line);
                    if (this.collectNamedElementsInRange(new TextRange(startOffset, endOffset))) {
                        return false;
                    }
                    this.$mappings.add(entry);
                }
                return true;
            }

            private final boolean collectNamedElementsInRange(TextRange range) {
                return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.$file)).onRange(range).filter(arg_0 -> getMappingsForElement.processor.1.collectNamedElementsInRange$lambda$1(arg_0 -> getMappingsForElement.processor.1.collectNamedElementsInRange$lambda$0(range, this.$namedElementsCounter, arg_0), arg_0))).traverse().isNotEmpty();
            }

            private static final boolean collectNamedElementsInRange$lambda$0(TextRange $range, AtomicInteger $namedElementsCounter, PsiElement it) {
                return it instanceof PsiNamedElement && $range.contains(((PsiNamedElement)it).getTextRange()) && $namedElementsCounter.incrementAndGet() > 1;
            }

            private static final boolean collectNamedElementsInRange$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
        if (!this.sourceMap.processSourceMappingsInLine(sourceEntry.getSource(), sourceEntry.getSourceLine(), processor2)) {
            return null;
        }
        return mappings;
    }

    public final void addMapping(@NotNull String generatedName, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter((Object)generatedName, (String)"generatedName");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        if (this.rawNameToSource == null) {
            this.rawNameToSource = new HashMap();
        }
        Map<String, String> map = this.rawNameToSource;
        Intrinsics.checkNotNull(map);
        map.put(generatedName, sourceName);
    }

    @Nullable
    protected String extractName(@Nullable CharSequence rawGeneratedName, @Nullable PsiElement context) {
        String string;
        CharSequence charSequence = rawGeneratedName;
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            string = NameMapperKt.getNAME_TRIMMER().trimFrom(it);
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String extractName$default(NameMapper nameMapper, CharSequence charSequence, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractName");
        }
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return nameMapper.extractName(charSequence, psiElement);
    }

    @Nullable
    protected CharSequence getGeneratedName(@NotNull PsiElement element, @NotNull Document document, @NotNull SourceMap sourceMap, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        MappingEntry sourceEntry = mappings.get(0);
        int lineStartOffset = document.getLineStartOffset(sourceEntry.getGeneratedLine());
        MappingEntry nextGeneratedMapping = sourceMap.getGeneratedMappings().getNextOnTheSameLine(sourceEntry);
        int endOffset = 0;
        endOffset = nextGeneratedMapping == null ? document.getLineEndOffset(sourceEntry.getGeneratedLine()) : lineStartOffset + nextGeneratedMapping.getGeneratedColumn();
        return document.getImmutableCharSequence().subSequence(lineStartOffset + sourceEntry.getGeneratedColumn(), endOffset);
    }

    @JvmOverloads
    @Nullable
    public final String map(@NotNull PsiElement identifierOrNamedElement) {
        Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        return NameMapper.map$default(this, identifierOrNamedElement, false, 2, null);
    }

    public static final /* synthetic */ Document access$getDocument$p(NameMapper $this) {
        return $this.document;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/NameMapper$Companion;", "", "<init>", "()V", "trimName", "", "rawGeneratedName", "", "isLastToken", "", "intellij.javascript.debugger.ui"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String trimName(@NotNull CharSequence rawGeneratedName, boolean isLastToken) {
            Intrinsics.checkNotNullParameter((Object)rawGeneratedName, (String)"rawGeneratedName");
            return (isLastToken ? NameMapperKt.getNAME_TRIMMER() : NameMapperKt.access$getOPERATOR_TRIMMER$p()).trimFrom(rawGeneratedName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

