/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import org.jetbrains.annotations.NotNull;

public final class AseDomains
extends BaseDomainRegistry {
    private static final double MAX_FLOAT = 1.0E307;
    private static final double MIN_FLOAT = -1.0E308;
    private static final int MONEY_SCALE = 4;
    private static final int MAX_VARCHAR = 16384;
    private static final int MAX_UNIVARCHAR = 8192;
    private static final int SMALLMONEY_PRECISION = 10;
    private static final int MAX_PRECISION = 38;
    private static final int MONEY_PRECISION = 19;
    private static final int MAX_TS_FRACTION = 6;

    public AseDomains() {
        this.add((Domain)new IntegerDomain("unsigned bigint", ConversionPoint.UNSIGNED_NUMBER, 0.0, DomainRegistry.CommonLimits.BIGINT_UNSIGNED_MAX));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 16384L, 1L, true, true).withAliases(new String[]{"character varying"}));
        this.add((Domain)new TextDomain("univarchar", ConversionPoint.NVARCHAR, 8192L, 1L, true, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 8192L, 1L, true, false).withAliases(new String[]{"char"}));
        this.add((Domain)new TextDomain("unichar", ConversionPoint.NCHAR, 8192L, 1L, true, false));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 8192L, 1L, true, false));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add(new Number2Domain("smallmoney", ConversionPoint.MONEY, 10, 4, false).withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS_AND_LIKE_ONLY));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 19, 4, false).withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS_AND_LIKE_ONLY));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E308, 1.0E307));
        this.add((Domain)new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 16384L, 1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 16384L, 1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add((Domain)new IntegerDomain("unsigned int", ConversionPoint.NUMBER, 0.0, 2.147483647E9));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases(new String[]{"int"}));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 0, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain(this, "smalldatetime", ConversionPoint.TIMESTAMP, 3, -1, false){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (domain.simpleName().equals(this.simpleName())) {
                    Compatibility compatibility = super.getCompatibility(domain);
                    if (compatibility == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return compatibility;
                }
                Compatibility compatibility = Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/sybase/AseDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/sybase/AseDomains$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
    }
}

