/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum NpmCommand {
    ACCESS,
    ADD("install", "add"),
    ADD_USER("adduser"),
    AUDIT,
    BIN,
    BUGS,
    BUILD,
    CACHE,
    CI,
    COMPLETION,
    CONFIG,
    DEDUPE,
    DEPRECATE,
    DIST_TAG("dist-tag"),
    DOCS,
    EDIT,
    EXEC,
    EXPLORE,
    HELP,
    HELP_SEARCH("help-search"),
    INIT,
    INSTALL,
    INFO,
    LINK,
    LOGOUT,
    LS,
    NPM,
    OUTDATED,
    OWNER,
    PACK,
    PING,
    PREFIX,
    PRUNE,
    PUBLISH,
    REBUILD,
    REPO,
    RESTART,
    ROOT,
    RUN_SCRIPT("run"),
    SEARCH,
    SHRINKWRAP,
    STAR,
    STARS,
    START,
    STOP,
    TAG,
    TEAM,
    TEST,
    UNINSTALL("uninstall", "remove"),
    UNPUBLISH,
    UPDATE("update", "upgrade"),
    VERSION,
    VIEW,
    WHOAMI;

    private final String myCliOption;
    private final String myYarnCliOption;

    private NpmCommand() {
        this.myYarnCliOption = this.myCliOption = StringUtil.toLowerCase((String)this.name());
    }

    private NpmCommand(String cliOption) {
        if (cliOption == null) {
            NpmCommand.$$$reportNull$$$0(0);
        }
        this(cliOption, cliOption);
    }

    private NpmCommand(String cliOption, String yarnCliOption) {
        if (cliOption == null) {
            NpmCommand.$$$reportNull$$$0(1);
        }
        this.myCliOption = cliOption;
        this.myYarnCliOption = StringUtil.notNullize((String)yarnCliOption, (String)cliOption);
    }

    @NotNull
    @NlsSafe
    public String getCliOption() {
        String string = this.myCliOption;
        if (string == null) {
            NpmCommand.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getCliOption(boolean yarn) {
        String string = yarn ? this.myYarnCliOption : this.myCliOption;
        if (string == null) {
            NpmCommand.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static List<NpmCommand> getCommands(boolean yarn) {
        ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(Arrays.asList(NpmCommand.values()));
        if (yarn) {
            commands.remove((Object)CI);
            commands.remove((Object)UPDATE);
        }
        return commands;
    }

    @NotNull
    public static List<NpmCommand> getStaticCommands(@NotNull NodePackageRef npmPkgRef) {
        if (npmPkgRef == null) {
            NpmCommand.$$$reportNull$$$0(4);
        }
        if (NpmUtil.isYarnAlikePackageRef(npmPkgRef)) {
            return NpmCommand.getYarnCommands();
        }
        if (NpmUtil.isBunPackageRef(npmPkgRef)) {
            return NpmCommand.getBunCommands();
        }
        return NpmCommand.getAllCommands();
    }

    @NotNull
    private static List<NpmCommand> getYarnCommands() {
        ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(NpmCommand.getAllCommands());
        commands.removeAll(List.of(CI, UPDATE));
        ArrayList<NpmCommand> arrayList = commands;
        if (arrayList == null) {
            NpmCommand.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<NpmCommand> getBunCommands() {
        List<NpmCommand> list = List.of(RUN_SCRIPT, TEST, INSTALL, UPDATE, OUTDATED, LINK, PUBLISH, BUILD, INIT);
        if (list == null) {
            NpmCommand.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<NpmCommand> getAllCommands() {
        List<NpmCommand> list = Arrays.asList(NpmCommand.values());
        if (list == null) {
            NpmCommand.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliOption";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliOption";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getYarnCommands";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBunCommands";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStaticCommands";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

