/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDocCommentFixer
implements DocCommentFixer {
    public void fixComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiComment comment) {
        JSFunction commentElement;
        if (project == null) {
            JSDocCommentFixer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSDocCommentFixer.$$$reportNull$$$0(1);
        }
        if (comment == null) {
            JSDocCommentFixer.$$$reportNull$$$0(2);
        }
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocComment docComment = (JSDocComment)comment;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        ArrayList<CallSite> tagsToAdd = new ArrayList<CallSite>();
        HashSet tagsToRemove = new HashSet();
        HashMap<Integer, CallSite> tagsToUpdate = new HashMap<Integer, CallSite>();
        JSFunction function = JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment);
        if (function != null) {
            JSType type2;
            commentElement = function;
            JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature((JSDocComment)docComment, (JSFunction)function);
            if (info != null) {
                List paramsToAdd = info.getParamsToAdd();
                for (Pair s : paramsToAdd) {
                    tagsToAdd.add((CallSite)((Object)("param " + (String)s.getSecond())));
                }
                tagsToRemove.addAll(info.getParamsToRemove().keySet());
            }
            if ((type2 = TypeFromUsageDetector.detectTypeFromUsage((PsiElement)function)) != null && !(type2 instanceof JSVoidType)) {
                JSDocTag[] tags = docComment.getTags();
                boolean returnTagFound = false;
                for (int i = 0; i < tags.length; ++i) {
                    JSDocTag tag = tags[i];
                    if (!tag.is((JSDocTagDefinition)JSDocBlockTags.RETURNS)) continue;
                    tagsToUpdate.put(i, (CallSite)((Object)("{" + type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}")));
                    returnTagFound = true;
                    break;
                }
                if (!returnTagFound) {
                    tagsToAdd.add((CallSite)((Object)("return {" + type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}")));
                }
            }
        } else {
            JSType type3;
            PsiElement element2 = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
            commentElement = element2;
            JSExpression exprForTypeEval = null;
            if (element2 instanceof JSVariable) {
                exprForTypeEval = ((JSVariable)element2).getInitializer();
            } else if (element2 instanceof JSProperty) {
                exprForTypeEval = ((JSProperty)element2).getValue();
            } else if (element2 instanceof JSExpression) {
                exprForTypeEval = (JSExpression)element2;
            }
            if (exprForTypeEval != null && (type3 = JSResolveUtil.getExpressionJSType((JSExpression)exprForTypeEval)) != null && (!(type3 instanceof JSAnyType) || type3.isSourceStrict())) {
                boolean typeTagFound = false;
                JSDocTag[] tags = docComment.getTags();
                for (int i = 0; i < tags.length; ++i) {
                    JSDocTag tag = tags[i];
                    if (!tag.is((JSDocTagDefinition)JSDocBlockTags.TYPE)) continue;
                    tagsToUpdate.put(i, (CallSite)((Object)("{" + type3.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}")));
                    typeTagFound = true;
                    break;
                }
                if (!typeTagFound) {
                    tagsToAdd.add((CallSite)((Object)("type {" + type3.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "}")));
                }
            }
        }
        if (commentElement != null) {
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)commentElement, tagsToAdd, tagsToUpdate, tagsToRemove);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "comment";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/documentation/JSDocCommentFixer";
        objectArray[2] = "fixComment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

