/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSHierarchyUtils {
    private static final Comparator<NodeDescriptor<?>> NODE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(NodeDescriptor::getIndex);

    public static Comparator<NodeDescriptor<?>> getComparator(Project project) {
        if (HierarchyBrowserManager.getInstance((Project)project).getState().SORT_ALPHABETICALLY) {
            return AlphaComparator.getInstance();
        }
        return NODE_DESCRIPTOR_COMPARATOR;
    }

    @Nullable
    public static <T extends PsiElement> T getElementFromContext(@NotNull DataContext dataContext, @NotNull Function<? super PsiElement, ? extends T> targetElementGetter) {
        Project project;
        if (dataContext == null) {
            JSHierarchyUtils.$$$reportNull$$$0(0);
        }
        if (targetElementGetter == null) {
            JSHierarchyUtils.$$$reportNull$$$0(1);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiElement targetElement = (PsiElement)targetElementGetter.apply((PsiElement)element2);
        if (targetElement != null) {
            return (T)targetElement;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file instanceof XmlFile) {
            Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file);
            if (injEditor instanceof EditorWindow) {
                PsiFile injFile = ((EditorWindow)injEditor).getInjectedFile();
                int offset = injEditor.getCaretModel().getOffset();
                element2 = injFile.findElementAt(offset);
            }
        } else if (file instanceof JSFile) {
            int offset = editor.getCaretModel().getOffset();
            element2 = file.findElementAt(offset);
        }
        return (T)((PsiElement)targetElementGetter.apply((PsiElement)element2));
    }

    @Nullable
    public static PsiElement getJSFunctionOrClass(JSCallExpression callExpression) {
        JSExpression methodExpression;
        JSExpression jSExpression = methodExpression = callExpression == null ? null : callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            PsiElement psiElement = ((JSReferenceExpression)methodExpression).resolve();
            if (psiElement instanceof JSClass && callExpression instanceof JSNewExpression) {
                return psiElement;
            }
            return JSHierarchyUtils.getJSFunction(psiElement);
        }
        return null;
    }

    @Nullable
    public static JSFunctionItem getJSFunction(@Nullable PsiElement element2) {
        JSExpression initializer;
        if (element2 == null) {
            return null;
        }
        PsiElement targetElement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JSFunctionItem.class, JSInitializerOwner.class, JSPsiReferenceElement.class});
        if (targetElement instanceof JSPsiReferenceElement) {
            targetElement = ((JSPsiReferenceElement)targetElement).resolve();
        }
        if (targetElement instanceof JSFunctionItem) {
            return (JSFunctionItem)targetElement;
        }
        if (targetElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)targetElement).getInitializer()) instanceof JSFunctionItem) {
            return (JSFunctionItem)initializer;
        }
        return null;
    }

    public static JSPsiElementBase getTypeHierarchyTargetElement(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiElement targetElement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JSPsiElementBase.class, JSPsiReferenceElement.class});
        if (targetElement instanceof JSPsiReferenceElement) {
            targetElement = ((JSPsiReferenceElement)targetElement).resolve();
        }
        if (targetElement instanceof JSPsiElementBase) {
            return (JSPsiElementBase)targetElement;
        }
        return null;
    }

    @Nullable
    public static String getQName(@NotNull JSPsiElementBase jsFunction) {
        if (jsFunction == null) {
            JSHierarchyUtils.$$$reportNull$$$0(2);
        }
        return jsFunction.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElementGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/hierarchy/JSHierarchyUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

