/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.lang.typescript.compiler.action.TypeScriptRestartServiceActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0016\b\u0016\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/typescript/compiler/action/TypeScriptRestartServiceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;)V", "myServiceName", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setEnableAndVisible", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "isEnabled", "", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTypeScriptRestartServiceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptRestartServiceAction.kt\ncom/intellij/lang/typescript/compiler/action/TypeScriptRestartServiceAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1761#2,3:60\n*S KotlinDebug\n*F\n+ 1 TypeScriptRestartServiceAction.kt\ncom/intellij/lang/typescript/compiler/action/TypeScriptRestartServiceAction\n*L\n46#1:60,3\n*E\n"})
public class TypeScriptRestartServiceAction
extends AnAction {
    @NotNull
    private final String myServiceName;

    public TypeScriptRestartServiceAction() {
        String string = JavaScriptBundle.message((String)"typescript.language.service.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myServiceName = string;
    }

    public TypeScriptRestartServiceAction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(JavaScriptBundle.messagePointer((String)"action.restart.service", (Object[])new Object[0]), AllIcons.Actions.StopAndRestart);
        this.myServiceName = name;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null) {
            TypeScriptServiceRestarter.restartServices(project);
            Object[] objectArray = new Object[]{this.myServiceName};
            String string = LangBundle.message((String)"language.services.0.restarted.notification.title", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            JSLanguageServiceUtil.showServiceStoppedOrRestartedNotification(project, title, "");
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Presentation presentation;
        block4: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            presentation = presentation2;
            if (project == null) {
                this.setEnableAndVisible(presentation, false);
                return;
            }
            Iterable $this$any$iv = TypeScriptServiceHolder.INSTANCE.getAllForProject(project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeScriptService p0 = (TypeScriptService)element$iv;
                    boolean bl2 = false;
                    if (!TypeScriptRestartServiceActionKt.isCreatedOrErroredService(p0)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hasRestartable = bl;
        this.setEnableAndVisible(presentation, hasRestartable);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void setEnableAndVisible(@NotNull Presentation presentation, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setEnabledAndVisible(isEnabled);
    }
}

