/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.declarative.HintFontSize;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPayload;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.OwnBypassCollector;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.codeInsight.hints.declarative.StringInlayActionPayload;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.typescript.editing.TypeScriptInlayHintsSupportedService;
import com.intellij.lang.typescript.intentions.TypeScriptAddExplicitEnumValuesIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeEnumValuesInlayProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "Collector", "OnlyToggleIntentionsCollector", "intellij.javascript.backend"})
public final class TypeScriptDeclarativeEnumValuesInlayProvider
implements InlayHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROVIDER_ID = "ts.enum.hints";
    @NotNull
    public static final String ENUM_ENTRY_TEXT_PAYLOAD = "ts.enum.text.payload";
    @NotNull
    public static final String ENUM_FIELD_PSI_PAYLOAD = "ts.enum.psi.payload";

    @NotNull
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return TypeScriptInlayHintsSupportedService.Companion.getSupported(file).getUseOwn() ? (InlayHintsCollector)new Collector() : (InlayHintsCollector)new OnlyToggleIntentionsCollector();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeEnumValuesInlayProvider$Collector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "()V", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "hintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "getNumberFormat", "Lcom/intellij/lang/typescript/intentions/TypeScriptAddExplicitEnumValuesIntention$NumberFormat;", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptEnumField;", "intellij.javascript.backend"})
    private static final class Collector
    implements SharedBypassCollector {
        @NotNull
        private final HintFormat hintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

        public void collectFromElement(@NotNull PsiElement element2, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (element2 instanceof TypeScriptEnumField && ((TypeScriptEnumField)element2).getInitializer() == null) {
                PsiElement nameIdentifier;
                String asString;
                Double numericValue;
                TypeScriptAddExplicitEnumValuesIntention.NumberFormat format = this.getNumberFormat((TypeScriptEnumField)element2);
                EnumConstantValue enumConstantValue = ((TypeScriptEnumField)element2).getConstantValue();
                Intrinsics.checkNotNullExpressionValue((Object)enumConstantValue, (String)"getConstantValue(...)");
                EnumConstantValue constantValue = enumConstantValue;
                Double d = numericValue = constantValue.getNumericValue();
                String string = asString = d != null ? TypeScriptAddExplicitEnumValuesIntention.formatNumber((int)d.doubleValue(), format) : constantValue.getAsString();
                if (asString != null && (nameIdentifier = ((TypeScriptEnumField)element2).getNameIdentifier()) != null) {
                    SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)element2);
                    Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
                    SmartPsiElementPointer fieldPointer = smartPsiElementPointer;
                    Object[] objectArray = new InlayPayload[]{new InlayPayload(TypeScriptDeclarativeEnumValuesInlayProvider.ENUM_FIELD_PSI_PAYLOAD, (InlayActionPayload)new PsiPointerInlayActionPayload(fieldPointer)), new InlayPayload(TypeScriptDeclarativeEnumValuesInlayProvider.ENUM_ENTRY_TEXT_PAYLOAD, (InlayActionPayload)new StringInlayActionPayload(asString))};
                    InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(nameIdentifier.getTextRange().getEndOffset(), true, 0, 4, null)), (List)CollectionsKt.listOf((Object[])objectArray), null, (HintFormat)this.hintFormat, arg_0 -> Collector.collectFromElement$lambda$0(asString, arg_0), (int)4, null);
                }
            }
        }

        private final TypeScriptAddExplicitEnumValuesIntention.NumberFormat getNumberFormat(TypeScriptEnumField element2) {
            TypeScriptAddExplicitEnumValuesIntention.NumberFormat format = TypeScriptAddExplicitEnumValuesIntention.NumberFormat.Dec;
            TypeScriptEnum owner = element2.getOwner();
            if (owner != null) {
                Object[] objectArray = owner.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getFields(...)");
                Object[] fields = objectArray;
                int ownIndex = ArrayUtil.indexOf((Object[])fields, (Object)element2);
                if (ownIndex > 0) {
                    for (int i = ownIndex - 1; -1 < i; --i) {
                        JSExpression initializer = fields[i].getInitializer();
                        if (initializer == null) continue;
                        TypeScriptAddExplicitEnumValuesIntention.NumberFormat numberFormat = TypeScriptAddExplicitEnumValuesIntention.getNumberFormat(initializer);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)numberFormat), (String)"getNumberFormat(...)");
                        format = numberFormat;
                        break;
                    }
                }
            }
            return format;
        }

        private static final Unit collectFromElement$lambda$0(String $asString, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)" = ", null, (int)2, null);
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$asString, null, (int)2, null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeEnumValuesInlayProvider$Companion;", "", "<init>", "()V", "PROVIDER_ID", "", "ENUM_ENTRY_TEXT_PAYLOAD", "ENUM_FIELD_PSI_PAYLOAD", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeEnumValuesInlayProvider$OnlyToggleIntentionsCollector;", "Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;", "<init>", "()V", "collectHintsForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "shouldSuggestToggling", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.javascript.backend"})
    @ApiStatus.Internal
    public static final class OnlyToggleIntentionsCollector
    implements OwnBypassCollector {
        public void collectHintsForFile(@NotNull PsiFile file, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        }

        public boolean shouldSuggestToggling(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
            if (psiElement == null) {
                return false;
            }
            PsiElement element2 = psiElement;
            TypeScriptEnumField typeScriptEnumField = (TypeScriptEnumField)PsiTreeUtil.getParentOfType((PsiElement)element2, TypeScriptEnumField.class);
            if (typeScriptEnumField == null) {
                return false;
            }
            TypeScriptEnumField enumField = typeScriptEnumField;
            return enumField.getInitializer() == null;
        }
    }
}

