/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import org.jetbrains.annotations.NotNull;

class CyclomaticComplexityVisitor
extends JSRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    public void visitJSElement(@NotNull JSElement jsElement) {
        if (jsElement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(0);
        }
        int oldComplexity = 0;
        if (jsElement instanceof JSFunction) {
            oldComplexity = this.complexity;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.complexity = oldComplexity;
        }
    }

    public void visitJSForStatement(@NotNull JSForStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(1);
        }
        super.visitJSForStatement(statement);
        ++this.complexity;
    }

    public void visitJSForInStatement(@NotNull JSForInStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(2);
        }
        super.visitJSForInStatement(statement);
        ++this.complexity;
    }

    public void visitJSIfStatement(@NotNull JSIfStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(3);
        }
        super.visitJSIfStatement(statement);
        ++this.complexity;
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(4);
        }
        super.visitJSDoWhileStatement(statement);
        ++this.complexity;
    }

    public void visitJSConditionalExpression(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(5);
        }
        super.visitJSConditionalExpression(expression);
        ++this.complexity;
    }

    public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
        JSCaseClause[] caseClauses;
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(6);
        }
        super.visitJSSwitchStatement(statement);
        for (JSCaseClause clause : caseClauses = statement.getCaseClauses()) {
            JSSourceElement[] statements = clause.getStatementListItems();
            if (statements.length == 0) continue;
            ++this.complexity;
        }
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(7);
        }
        super.visitJSWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForInStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSIfStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDoWhileStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSConditionalExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSSwitchStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSWhileStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

