/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.persistence.database.config.impl.DataSourceKeyType;
import com.intellij.persistence.database.config.impl.urlParser.CommonDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.persistence.database.config.impl.urlParser.MongoUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.RawDatabaseUrl;
import com.intellij.quarkus.config.datasource.QsConfigPropertyValueSearcher;
import com.intellij.quarkus.config.datasource.QsConfigProvider;
import com.intellij.quarkus.config.datasource.QsMongoDataSourcesKeyTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/quarkus/config/datasource/QsMongoDataSourceConfigProvider;", "Lcom/intellij/quarkus/config/datasource/QsConfigProvider;", "<init>", "()V", "getConfigs", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "propertyInfo", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "retrieveUrls", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "collected", "", "Lcom/intellij/persistence/database/config/impl/DataSourceKeyType;", "", "databaseName", "templateUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/CommonDatabaseUrl;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsMongoDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsMongoDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsMongoDataSourceConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1563#2:74\n1634#2,3:75\n1617#2,9:79\n1869#2:88\n1870#2:90\n1626#2:91\n1617#2,9:92\n1869#2:101\n1870#2:103\n1626#2:104\n1#3:78\n1#3:89\n1#3:102\n*S KotlinDebug\n*F\n+ 1 QsMongoDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsMongoDataSourceConfigProvider\n*L\n30#1:74\n30#1:75,3\n58#1:79,9\n58#1:88\n58#1:90\n58#1:91\n59#1:92,9\n59#1:101\n59#1:103\n59#1:104\n58#1:89\n59#1:102\n*E\n"})
public final class QsMongoDataSourceConfigProvider
extends QsConfigProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RecognizedDatabaseConfig> getConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull DataSourcePropertyWithPrefixDataInfo propertyInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)DatabaseType.MONGODB);
        if (databaseDriver == null) {
            return CollectionsKt.emptyList();
        }
        DatabaseDriver driver = databaseDriver;
        QsConfigPropertyValueSearcher valueSearcher = new QsConfigPropertyValueSearcher(fileInfo, propertyInfo.getDocumentId());
        Map collected = this.collectValues((List)QsMongoDataSourcesKeyTypes.getEntries(), propertyInfo, valueSearcher);
        String string = (String)collected.get((Object)QsMongoDataSourcesKeyTypes.QS_MONGO_DATABASE);
        if (string == null) {
            string = propertyInfo.getKeyPrefixInfo().getDatabaseName();
        }
        String database = string;
        String string2 = driver.getSampleUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSampleUrl(...)");
        CommonDatabaseUrl templateUrl = DatabaseUrlParserKt.parseToCommonDatabaseUrl$default((String)string2, (String)database, null, null, (int)12, null);
        Iterable $this$map$iv = this.retrieveUrls(collected, database, templateUrl);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            String string3;
            void parsed;
            DatabaseUrl databaseUrl = (DatabaseUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string4 = parsed.toDbDialogUrl();
            String string5 = driver.getDriverClass();
            String string6 = parsed.username();
            if (string6 == null) {
                string6 = (String)collected.get((Object)QsMongoDataSourcesKeyTypes.QS_MONGO_USER);
            }
            if ((string3 = parsed.password()) == null) {
                string3 = (String)collected.get((Object)QsMongoDataSourcesKeyTypes.QS_MONGO_PASSWORD);
            }
            if ((object = parsed.dataSourceItemName()) == null) {
                object = "mongo@" + parsed.host();
            }
            collection.add(new RecognizedDatabaseConfig(string4, string5, string6, string3, (String)object));
        }
        return (List)destination$iv$iv;
    }

    private final List<DatabaseUrl> retrieveUrls(Map<DataSourceKeyType, String> collected, String databaseName, CommonDatabaseUrl templateUrl) {
        List list;
        List urls = new ArrayList();
        String connectionString = collected.get((Object)QsMongoDataSourcesKeyTypes.QS_MONGO_CONNECTION_STRING);
        if (connectionString != null) {
            List list2;
            List it = list2 = MongoUrlParserKt.parseMongoUrl((String)connectionString, (String)databaseName);
            boolean bl = false;
            List list3 = !((Collection)it).isEmpty() ? list2 : null;
            if (list3 == null) {
                list3 = CollectionsKt.listOf((Object)new RawDatabaseUrl(DatabaseType.MONGODB, databaseName, connectionString));
            }
            List mongoUrls = list3;
            urls.addAll(mongoUrls);
        }
        String string = collected.get((Object)QsMongoDataSourcesKeyTypes.QS_MONGO_HOSTS);
        if (string != null) {
            boolean bl;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            String hosts = string;
            boolean bl2 = false;
            CommonDatabaseUrl commonDatabaseUrl = templateUrl;
            if (commonDatabaseUrl == null) {
                return CollectionsKt.emptyList();
            }
            CommonDatabaseUrl templateUrlValue = commonDatabaseUrl;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)hosts, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            void var14_15 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if ((((CharSequence)it).length() == 0 ? null : ((Object)StringsKt.trim((CharSequence)it)).toString()) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CommonDatabaseUrl commonDatabaseUrl2;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl = false;
                String hostPort = (String)element$iv$iv;
                boolean bl5 = false;
                if (DatabaseUrlParserKt.retrieveHostAndPort$default((String)hostPort, null, (Integer)templateUrl.getPort(), (int)2, null) == null) {
                    commonDatabaseUrl2 = null;
                } else {
                    Pair pair;
                    String host = (String)pair.component1();
                    Integer port = (Integer)pair.component2();
                    commonDatabaseUrl2 = CommonDatabaseUrl.copy$default((CommonDatabaseUrl)templateUrlValue, null, null, null, (String)host, (Integer)port, null, null, null, (int)231, null);
                }
                if (commonDatabaseUrl2 == null) continue;
                CommonDatabaseUrl it$iv$iv = commonDatabaseUrl2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List parsedUrls = list;
        urls.addAll(parsedUrls);
        if (urls.isEmpty() && templateUrl != null) {
            urls.add(CommonDatabaseUrl.copy$default((CommonDatabaseUrl)templateUrl, null, null, (String)databaseName, null, null, null, null, null, (int)251, null));
        }
        return urls;
    }
}

