/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0006"}, d2={"getTemplateFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeTemplateLanguage", "Lcom/intellij/lang/Language;", "intellij.quarkus"})
public final class QuteFileViewProviderKt {
    @Nullable
    public static final FileType getTemplateFileType(@Nullable VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (virtualFile == null) {
            return null;
        }
        List list = StringUtil.split((String)virtualFile.getName(), (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        String string = (String)CollectionsKt.lastOrNull((List)list);
        if (string == null) {
            return null;
        }
        String extension = string;
        FileType fileType = fileTypeManager.getFileTypeByExtension(extension);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType fileType2 = fileType;
        return fileType2 == UnknownFileType.INSTANCE ? null : fileType2;
    }

    @NotNull
    public static final Language computeTemplateLanguage(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileType fileType = QuteFileViewProviderKt.getTemplateFileType(virtualFile);
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            return (Language)HTMLLanguage.INSTANCE;
        }
        LanguageFileType fileType2 = languageFileType;
        Language language = fileType2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        return language2 instanceof TemplateLanguage ? (Language)HTMLLanguage.INSTANCE : language2;
    }
}

