/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.hibernate.CriteriaApiReferenceProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public final class CriteriaApiResolveInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CriteriaApiResolveInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                CriteriaApiResolveInspection.checkQueryApiReferences(expression, holder, isOnTheFly);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static void checkQueryApiReferences(PsiLiteralExpression literalExpression, ProblemsHolder holder, boolean isOnTheFly) {
        if (!CriteriaApiReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression)) {
            return;
        }
        JpaUtil.processReferencesOfType((PsiReference[])literalExpression.getReferences(), CriteriaApiReferenceProvider.CriteriaAttributeReference.class, reference -> {
            boolean badResolve;
            boolean bl = badResolve = reference.resolve() == null;
            if (badResolve) {
                String message = MessageFormat.format(reference.getUnresolvedMessagePattern(), reference.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, reference.getQuickFixes()));
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "buildVisitor"));
    }
}

