/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.console52.remote;

import com.intellij.hibernate.console52.remote.HibernateFacadeImpl;
import com.intellij.hibernate.console52.remote.RemoteSessionImpl;
import com.intellij.hibernate.remote.RemoteSession;
import com.intellij.hibernate.remote.impl.BaseRemoteSessionFactory;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collections;
import org.hibernate.SessionFactory;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.spi.QueryTranslator;

public class RemoteSessionFactoryImpl
extends BaseRemoteSessionFactory {
    protected RemoteSessionFactoryImpl(SessionFactory delegate) {
        super(delegate);
    }

    public RemoteSession openSession() throws RemoteException {
        try {
            return (RemoteSession)this.export((Remote)RemoteSessionImpl.wrap(this.getDelegate().openSession()));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public RemoteSession getCurrentSession() throws RemoteException {
        try {
            return (RemoteSession)this.export((Remote)RemoteSessionImpl.wrap(this.getDelegate().getCurrentSession()));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public static RemoteSessionFactoryImpl wrap(SessionFactory delegate) {
        return new RemoteSessionFactoryImpl(delegate);
    }

    protected String generateSqlInner(String query) {
        HQLQueryPlan plan = new HQLQueryPlan(query, false, Collections.emptyMap(), (SessionFactoryImplementor)this.getDelegate());
        StringBuilder sb = new StringBuilder();
        for (QueryTranslator translator : plan.getTranslators()) {
            for (String o : translator.collectSqlStrings()) {
                String formattedSql = HibernateFacadeImpl.ourFormatter.formatSQL(o);
                sb.append(formattedSql);
            }
        }
        return sb.toString();
    }
}

