/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementImpl<D>
extends FakePsiElement
implements DbElement,
PsiMetaOwner,
PsiPresentableMetaData {
    private static final Logger LOG = Logger.getInstance(DbElementImpl.class);
    public static final int WEIGHT_BASE = 10000;
    public static final int WEIGHT_INC = 1000;
    @NotNull
    protected final D myDelegate;
    protected volatile long myTransactionalVersion;
    protected static final String ASYNC_DOC_CUT = "<!-- async-doc-cut -->";

    public DbElementImpl(@NotNull D delegate) {
        if (delegate == null) {
            DbElementImpl.$$$reportNull$$$0(0);
        }
        this.myTransactionalVersion = -1L;
        this.myDelegate = delegate;
    }

    @NotNull
    public D getDelegate() {
        D d = this.myDelegate;
        if (d == null) {
            DbElementImpl.$$$reportNull$$$0(1);
        }
        return d;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = DasUtil.NO_NAME;
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getVirtualFile() {
        return DatabaseElementVirtualFileImpl.findFile((DbElement)this, (boolean)true);
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
    }

    @NotNull
    public JBIterable<DbElement> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable jBIterable = this.getDataSource().findChildren(this).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public String getText() {
        return DatabaseDefinitionHelper.generateDefinition(this, new StringBuilder()).toString();
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @NotNull
    public String getTypeName() {
        String string = DbPresentationCore.getPresentableName((ObjectKind)this.getKind(), (Dbms)DbImplUtilCore.getDbms((DbElement)this));
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = super.getChildren();
        if (psiElementArray == null) {
            DbElementImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            DbElementImpl.$$$reportNull$$$0(7);
        }
        for (DbElement element : this.getDasChildren(null)) {
            element.accept(visitor);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        DatabaseUiService.getInstance().navigateToSource(this, requestFocus);
    }

    @NotNull
    public StringBuilder getDocumentation(boolean hover) {
        StringBuilder stringBuilder = this.getDocumentationBase();
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(8);
        }
        return stringBuilder;
    }

    @NotNull
    public StringBuilder getDocumentationBase() {
        StringBuilder stringBuilder = (StringBuilder)this.createDocHeaderColored().cast(StringBuilder.class);
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(9);
        }
        return stringBuilder;
    }

    @NotNull
    protected ColoredDdlBuilder createDocHeaderColored() {
        ColoredDdlBuilder colored = this.createDocBuilder(this.createDocHeaderDefault());
        String comment = this.getComment();
        if (StringUtil.isNotEmpty((String)comment)) {
            colored.plain("<br>").plain("-- " + comment, DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        ColoredDdlBuilder coloredDdlBuilder = colored;
        if (coloredDdlBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(10);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    protected StringBuilder createDocHeaderDefault() {
        Pair pair;
        ArrayList<DbElementImpl> elements = new ArrayList<DbElementImpl>();
        for (DbElementImpl cur = this; cur != null; cur = cur.getParent()) {
            String name = cur.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            elements.add(0, cur);
        }
        HtmlBuilder builder = new HtmlBuilder();
        for (DbElement dbElement : elements) {
            builder.append((HtmlChunk)HtmlChunk.text((String)(StringUtil.capitalizeWords((String)dbElement.getTypeName(), (boolean)true) + ":")).bold()).append(" ").append(dbElement.getName()).br();
        }
        D delegate = this.getDelegate();
        Pair pair2 = pair = delegate instanceof BasicElement ? ModelFacade.forDbms((Dbms)this.getDataSource().getDbms()).getModelHelper().getDocumentationLink((BasicElement)delegate) : null;
        if (pair != null) {
            HtmlChunk.Element linkLine = new HtmlBuilder().append(DatabaseBundle.message((String)"documentation", (Object[])new Object[0])).append(": ").append((HtmlChunk)HtmlChunk.link((String)((String)pair.second), (String)((String)pair.first)).wrapWith("tt")).wrapWith("b");
            builder.br().append((HtmlChunk)linkLine).br();
        }
        StringBuilder stringBuilder = new StringBuilder(DisplayHtmlValuesExtractor.getHeader()).append(builder);
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    protected void scheduleAsyncDocumentationUpdate(@NotNull CharSequence prefix, @NotNull AsyncDocGetter docGetter) {
        if (prefix == null) {
            DbElementImpl.$$$reportNull$$$0(12);
        }
        if (docGetter == null) {
            DbElementImpl.$$$reportNull$$$0(13);
        }
        String connectingToDatabasePhrase = DatabaseBundle.message((String)"connecting.to.database.ellipsis", (Object[])new Object[0]);
        String progressMessage = "<br><small>" + connectingToDatabasePhrase + "</small>";
        DatabaseUiService.getInstance().updateQuickDocAsync((PsiElement)this, prefix, (Consumer<Consumer<Object>>)((Consumer)out -> {
            block5: {
                try {
                    Appendable appendable = new Appendable(){
                        final /* synthetic */ Consumer val$out;
                        {
                            this.val$out = consumer;
                        }

                        @Override
                        public Appendable append(CharSequence csq) {
                            this.val$out.consume((Object)csq);
                            return this;
                        }

                        @Override
                        public Appendable append(CharSequence csq, int start2, int end) {
                            return this.append(csq.subSequence(start2, end));
                        }

                        @Override
                        public Appendable append(char c) {
                            this.val$out.consume((Object)Character.valueOf(c));
                            return this;
                        }
                    };
                    docGetter.beforeGet(appendable);
                    if (!DatabaseSettings.getSettings().loadSlowDocumentation) {
                        return;
                    }
                    if (!DbImplUtilCore.canConnectTo((DbElement)this)) {
                        return;
                    }
                    out.consume((Object)ASYNC_DOC_CUT);
                    out.consume((Object)progressMessage);
                    out.consume((Object)docGetter.asyncDocCut());
                    out.consume((Object)ASYNC_DOC_CUT);
                    TimeoutUtil.sleep((long)1000L);
                    ConnectionProvider.runWithProvider(this, (DatabaseDepartment)DGDepartment.QUICK_DOCUMENTATION, (ThrowableConsumer<ConnectionProvider, Exception>)((ThrowableConsumer)arg_0 -> DbElementImpl.lambda$scheduleAsyncDocumentationUpdate$0(docGetter, appendable, arg_0)));
                }
                catch (ProcessCanceledException e) {
                    String connectionCanceledPhrase = DatabaseBundle.message((String)"connection.canceled", (Object[])new Object[0]);
                    out.consume((Object)docGetter.asyncDocCut());
                    out.consume((Object)progressMessage);
                    out.consume((Object)("<br><b>" + connectionCanceledPhrase + "</b>"));
                }
                catch (Exception e) {
                    String connectionFailedPhrase = DatabaseBundle.message((String)"connection.failed", (Object[])new Object[0]);
                    out.consume((Object)docGetter.asyncDocCut());
                    out.consume((Object)progressMessage);
                    out.consume((Object)DataSourceUtil.exceptionToHtml(e, "<br><b>" + connectionFailedPhrase + "</b>", new StringBuilder()));
                    if (e instanceof SQLException || e instanceof IOException) break block5;
                    LOG.warn((Throwable)e);
                }
            }
        }));
    }

    protected boolean appendDefinition(@NotNull StringBuilder sb) {
        String text;
        if (sb == null) {
            DbElementImpl.$$$reportNull$$$0(14);
        }
        if ((text = DbImplUtil.loadDefinitionFromStorage(this)) == null && DatabaseEditorHelperCore.isDefinitionAvailable((DbElement)this)) {
            StringBuilder tmp = new StringBuilder();
            DatabaseDefinitionHelper.generateDefinition(this, tmp);
            if (tmp.isEmpty()) {
                return false;
            }
            tmp.insert(0, "-- auto-generated definition\n");
            text = tmp.toString();
        }
        if (text != null) {
            sb.append("<br><code><pre>");
            sb.append(this.sql2Html(text));
            while (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("</pre></code>");
            return true;
        }
        return false;
    }

    protected ColoredDdlBuilder createDocBuilder(StringBuilder sb) {
        ColoredDdlBuilder colored = new ColoredDdlBuilder(sb);
        colored.configureFor(this);
        return colored;
    }

    protected void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this);
    }

    @NotNull
    public abstract DbDataSourceImpl getDataSource();

    public int getWeight() {
        return 10000;
    }

    @NotNull
    protected String sql2Html(CharSequence s) {
        String string = DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtilCore.getSqlDialect((DbElement)this), s);
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static Processor<DbElement> newDeclarationProcessor(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(16);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(17);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(18);
        }
        Processor processor2 = element -> {
            if (lastParent == element) {
                return true;
            }
            return processor.execute((DasSymbol)element, state);
        };
        if (processor2 == null) {
            DbElementImpl.$$$reportNull$$$0(19);
        }
        return processor2;
    }

    @NotNull
    public Processor<DbElement> createDeclarationProcessor(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(20);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(21);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(22);
        }
        return DbElementImpl.newDeclarationProcessor(processor, state, lastParent, place);
    }

    public final boolean processDeclarations(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        JBIterable<DbDataSource> parents;
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(23);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(24);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(25);
        }
        Processor<DbElement> p2 = this.createDeclarationProcessor(processor, state, lastParent, place);
        JBIterable elements = JBIterable.empty();
        DasObject obj = (DasObject)ObjectUtils.tryCast(this.getDelegate(), DasObject.class);
        if (obj == null || DbImplUtil.isExpandable((DasObject)obj, (TreePattern)DbImplUtil.getIntrospectionScope((DasDataSource)this.getDataSource()))) {
            elements = elements.append(this.getDasChildren(null));
        }
        if (this instanceof DbNamespaceImpl && !(parents = DbElementImpl.getParentDataSources(this.getDataSource())).isEmpty()) {
            ObjectPath path = ObjectPaths.of((DasObject)this);
            JBIterable additional = parents.flatten(ds -> DbSqlUtilCore.findObjects((DbDataSource)ds, (ObjectPath)path).flatten(ns -> ns.getDasChildren(null)).map(o -> DbImplUtilCore.findElement((DbDataSource)ds, (DasObject)o)));
            elements = elements.append((Iterable)additional).filter((Condition)new DbImplUtilCore.HashingStrategyUnique<DbElement>(this){

                public int hashCode(DbElement object) {
                    return object == null ? 0 : object.getName().hashCode() + 31 * object.getKind().hashCode();
                }

                public boolean equals(DbElement o1, DbElement o2) {
                    if (o1 == o2 || o1 == null || o2 == null) {
                        return o1 == o2;
                    }
                    return o1.getName().equals(o2.getName()) && o1.getKind() == o2.getKind();
                }
            });
        }
        return ContainerUtil.process((Iterable)elements, p2);
    }

    @NotNull
    private static JBIterable<DbDataSource> getParentDataSources(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            DbElementImpl.$$$reportNull$$$0(26);
        }
        if (!(dataSource.getDelegate() instanceof SqlDataSource)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbElementImpl.$$$reportNull$$$0(27);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)dataSource, o -> {
            RawDataSource delegate = o.getDelegate();
            return delegate instanceof SqlDataSource ? ((SqlDataSource)delegate).getParentDataSource() : null;
        });
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    public String toString() {
        ObjectKind kind = this.getKind();
        String s = kind == ObjectKind.SCHEMA ? QNameUtil.getQualifiedName((DbElement)this) : (this instanceof DbTableChild ? this.getText() : this.getName());
        return s + ": " + String.valueOf(kind);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ void lambda$scheduleAsyncDocumentationUpdate$0(AsyncDocGetter docGetter, 1 appendable, ConnectionProvider provider) throws Exception {
        docGetter.get(appendable, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 8, 9, 10, 11, 15, 19, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docGetter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderColored";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeclarationProcessor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 27: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncDocumentationUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendDefinition";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newDeclarationProcessor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationProcessor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentDataSources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 8, 9, 10, 11, 15, 19, 27, 28 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    protected static interface AsyncDocGetter {
        public void get(@NotNull Appendable var1, @NotNull ConnectionProvider var2) throws Exception;

        default public void beforeGet(@NotNull Appendable consumer) {
            if (consumer == null) {
                AsyncDocGetter.$$$reportNull$$$0(0);
            }
        }

        default public String asyncDocCut() {
            return DbElementImpl.ASYNC_DOC_CUT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/psi/DbElementImpl$AsyncDocGetter", "beforeGet"));
        }
    }
}

