/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPointcutTypes;
import com.intellij.aop.psi.AopPrattParser;
import com.intellij.aop.psi.PointcutDescriptor;
import com.intellij.platform.pratt.MutableMarker;
import com.intellij.platform.pratt.PrattBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;

public abstract class MethodPointcutDescriptor
extends PointcutDescriptor {
    private final boolean myConstructorOnly;

    protected MethodPointcutDescriptor(@NonNls String tokenText, boolean constructorOnly) {
        super(tokenText);
        this.myConstructorOnly = constructorOnly;
    }

    @Override
    public void parseToken(PrattBuilder builder) {
        if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
            boolean isConstructor;
            MethodPointcutDescriptor.parseAnnotationsWithModifiers(builder);
            MutableMarker type = builder.mark();
            String message = this.myConstructorOnly ? AopBundle.message("error.constructor.pattern.expected", new Object[0]) : AopBundle.message("error.method.return.type.expected", new Object[0]);
            IElementType result = builder.parseChildren(70, message);
            boolean bl = isConstructor = result == AopElementTypes.AOP_CONSTRUCTOR_REFERENCE_EXPRESSION;
            if (!isConstructor) {
                if (this.myConstructorOnly) {
                    builder.error(AopBundle.message("error.0.expected", ".new"));
                    type.finish((IElementType)AopElementTypes.AOP_CONSTRUCTOR_REFERENCE_EXPRESSION);
                } else {
                    type.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                }
            } else {
                type.drop();
            }
            if (!isConstructor && !this.myConstructorOnly) {
                MutableMarker methodRef = builder.mark();
                builder.parseChildren(70, AopBundle.message("error.method.name.pattern.expected", new Object[0]));
                methodRef.finish((IElementType)AopElementTypes.AOP_MEMBER_REFERENCE_EXPRESSION);
            }
            if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
                AopPointcutTypes.parseFormalParameterList(builder);
                if (builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")")) && builder.isToken((IElementType)AopElementTypes.AOP_THROWS)) {
                    MutableMarker throwsList = builder.mark();
                    builder.advance();
                    do {
                        MutableMarker exc = builder.mark();
                        builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                        exc.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                    } while (builder.checkToken((IElementType)AopElementTypes.AOP_COMMA));
                    throwsList.finish((IElementType)AopElementTypes.AOP_THROWS_LIST);
                }
            }
            builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
        }
    }

    public static void parseAnnotationsWithModifiers(PrattBuilder builder) {
        if (builder.isToken((IElementType)AopElementTypes.AOP_AT) || builder.isToken((IElementType)AopElementTypes.AOP_NOT)) {
            AopPrattParser.parseAnnotations(builder);
        }
        MutableMarker modList = builder.mark();
        while (true) {
            if (AopElementTypes.AOP_NOT == builder.getTokenType()) {
                MutableMarker not = builder.mark();
                builder.advance();
                if (builder.isToken((IElementType)AopElementTypes.AOP_MODIFIER)) {
                    builder.advance();
                    not.finish((IElementType)AopElementTypes.AOP_NOT_EXPRESSION);
                    continue;
                }
                not.rollback();
                break;
            }
            if (!builder.isToken((IElementType)AopElementTypes.AOP_MODIFIER)) break;
            builder.advance();
        }
        modList.finish((IElementType)AopElementTypes.AOP_MODIFIER_LIST);
    }
}

