/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.google.common.base.Ascii;
import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbTextField;
import com.intellij.protobuf.lang.psi.PbTextNumberValue;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.impl.PbTextElementBase;
import com.intellij.protobuf.lang.resolve.PbEnumNumberReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

abstract class PbTextNumberValueMixin
extends PbTextElementBase
implements PbTextNumberValue {
    private static final TokenSet NUMBER_TOKENS = TokenSet.create((IElementType[])new IElementType[]{ProtoTokenTypes.INTEGER_LITERAL, ProtoTokenTypes.FLOAT_LITERAL, ProtoTokenTypes.IDENTIFIER_LITERAL});

    PbTextNumberValueMixin(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public ProtoNumberValue.SourceType getSourceType() {
        ASTNode childNode;
        PsiElement childElement = this.getNumberElement();
        ASTNode aSTNode = childNode = childElement != null ? childElement.getNode() : null;
        if (childNode != null) {
            IElementType numberType = childNode.getElementType();
            if (numberType == ProtoTokenTypes.INTEGER_LITERAL) {
                return ProtoNumberValue.SourceType.INTEGER;
            }
            if (numberType == ProtoTokenTypes.FLOAT_LITERAL) {
                return ProtoNumberValue.SourceType.FLOAT;
            }
            if (PbTextNumberValueMixin.isInf(childNode)) {
                return ProtoNumberValue.SourceType.INF;
            }
            if (PbTextNumberValueMixin.isNan(childNode)) {
                return ProtoNumberValue.SourceType.NAN;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getNumberElement() {
        return this.findChildByType(NUMBER_TOKENS);
    }

    @Override
    public boolean isNegative() {
        return this.findChildByType(ProtoTokenTypes.MINUS) != null;
    }

    @Override
    public Boolean getBooleanValue() {
        if (this.isNegative()) {
            return null;
        }
        Long longValue = this.getLongValue();
        if (longValue == null) {
            return null;
        }
        if (longValue == 0L) {
            return Boolean.FALSE;
        }
        if (longValue == 1L) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Nullable
    public PsiReference getReference() {
        if (!this.isValidInt32()) {
            return null;
        }
        PbTextField field = (PbTextField)PsiTreeUtil.getParentOfType((PsiElement)this, PbTextField.class);
        if (field == null) {
            return null;
        }
        PbNamedTypeElement namedTypeElement = field.getFieldName().getDeclaredNamedType();
        if (namedTypeElement instanceof PbEnumDefinition) {
            return new PbEnumNumberReference(this, (PbEnumDefinition)namedTypeElement);
        }
        return null;
    }

    private static boolean isInf(ASTNode node) {
        String text = Ascii.toLowerCase((String)node.getText());
        return Objects.equals(node.getElementType(), ProtoTokenTypes.IDENTIFIER_LITERAL) && ("inf".equals(text) || "infinity".equals(text));
    }

    private static boolean isNan(ASTNode node) {
        String text = Ascii.toLowerCase((String)node.getText());
        return Objects.equals(node.getElementType(), ProtoTokenTypes.IDENTIFIER_LITERAL) && "nan".equals(text);
    }
}

