/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.postcss.lexer.PostCssHighlightingLexer;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.jetbrains.annotations.NotNull;

public class PostCssSyntaxHighlighter
extends CssHighlighter {
    private static final Map<IElementType, TextAttributesKey> mapping;
    public static final TextAttributesKey KEYWORD;
    public static final TextAttributesKey IDENTIFIER;
    public static final TextAttributesKey STRING;
    public static final TextAttributesKey IMPORTANT;
    public static final TextAttributesKey PROPERTY_NAME;
    public static final TextAttributesKey PROPERTY_VALUE;
    public static final TextAttributesKey UNIT;
    public static final TextAttributesKey FUNCTION;
    public static final TextAttributesKey URL;
    public static final TextAttributesKey NUMBER;
    public static final TextAttributesKey COLOR;
    public static final TextAttributesKey PSEUDO;
    public static final TextAttributesKey COMMENT;
    public static final TextAttributesKey TAG_NAME;
    public static final TextAttributesKey ID_SELECTOR;
    public static final TextAttributesKey CLASS_NAME;
    public static final TextAttributesKey ATTRIBUTE_NAME;
    public static final TextAttributesKey UNICODE_RANGE;
    public static final TextAttributesKey PARENTHESES;
    public static final TextAttributesKey BRACKETS;
    public static final TextAttributesKey BRACES;
    public static final TextAttributesKey DOT;
    public static final TextAttributesKey SEMICOLON;
    public static final TextAttributesKey COLON;
    public static final TextAttributesKey COMMA;
    public static final TextAttributesKey OPERATORS;
    public static final TextAttributesKey BAD_CHARACTER;
    public static final TextAttributesKey AMPERSAND;

    @NotNull
    public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
        MultiMap map = MultiMap.create();
        map.putAllValues(mapping);
        MultiMap multiMap = map;
        if (multiMap == null) {
            PostCssSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PostCssHighlightingLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (mapping.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = PostCssSyntaxHighlighter.pack((TextAttributesKey)mapping.get(tokenType));
            if (textAttributesKeyArray == null) {
                PostCssSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            PostCssSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    static {
        KEYWORD = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_KEYWORD", (TextAttributesKey)CssHighlighter.CSS_KEYWORD);
        IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_IDENT", (TextAttributesKey)CssHighlighter.CSS_IDENT);
        STRING = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_STRING", (TextAttributesKey)CssHighlighter.CSS_STRING);
        IMPORTANT = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_IMPORTANT", (TextAttributesKey)CssHighlighter.CSS_IMPORTANT);
        PROPERTY_NAME = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_PROPERTY_NAME", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_NAME);
        PROPERTY_VALUE = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_PROPERTY_VALUE", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_VALUE);
        UNIT = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_UNIT", (TextAttributesKey)CssHighlighter.CSS_UNIT);
        FUNCTION = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_FUNCTION", (TextAttributesKey)CssHighlighter.CSS_FUNCTION);
        URL = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_URL", (TextAttributesKey)CssHighlighter.CSS_URL);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_NUMBER", (TextAttributesKey)CssHighlighter.CSS_NUMBER);
        COLOR = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_COLOR", (TextAttributesKey)CssHighlighter.CSS_COLOR);
        PSEUDO = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_PSEUDO", (TextAttributesKey)CssHighlighter.CSS_PSEUDO);
        COMMENT = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_COMMENT", (TextAttributesKey)CssHighlighter.CSS_COMMENT);
        TAG_NAME = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_TAG_NAME", (TextAttributesKey)CssHighlighter.CSS_TAG_NAME);
        ID_SELECTOR = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_ID_SELECTOR", (TextAttributesKey)CssHighlighter.CSS_ID_SELECTOR);
        CLASS_NAME = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_CLASS_NAME", (TextAttributesKey)CssHighlighter.CSS_CLASS_NAME);
        ATTRIBUTE_NAME = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_ATTRIBUTE_NAME", (TextAttributesKey)CssHighlighter.CSS_ATTRIBUTE_NAME);
        UNICODE_RANGE = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_UNICODE_RANGE", (TextAttributesKey)CssHighlighter.CSS_UNICODE_RANGE);
        PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_PARENTHESES", (TextAttributesKey)CssHighlighter.CSS_PARENTHESES);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_BRACKETS", (TextAttributesKey)CssHighlighter.CSS_BRACKETS);
        BRACES = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_BRACES", (TextAttributesKey)CssHighlighter.CSS_BRACES);
        DOT = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_DOT", (TextAttributesKey)CssHighlighter.CSS_DOT);
        SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_SEMICOLON", (TextAttributesKey)CssHighlighter.CSS_SEMICOLON);
        COLON = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_COLON", (TextAttributesKey)CssHighlighter.CSS_COLON);
        COMMA = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_COMMA", (TextAttributesKey)CssHighlighter.CSS_COMMA);
        OPERATORS = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_OPERATORS", (TextAttributesKey)CssHighlighter.CSS_OPERATORS);
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_BAD_CHARACTER", (TextAttributesKey)CssHighlighter.CSS_BAD_CHARACTER);
        AMPERSAND = TextAttributesKey.createTextAttributesKey((String)"POST_CSS_AMPERSAND", (TextAttributesKey)CssHighlighter.CSS_AMPERSAND_SELECTOR);
        mapping = new HashMap<IElementType, TextAttributesKey>();
        mapping.put(CssElementTypes.CSS_HASH, ID_SELECTOR);
        mapping.put(CssElementTypes.CSS_ATTRIBUTE_NAME, ATTRIBUTE_NAME);
        mapping.put(CssElementTypes.CSS_CLASS_NAME, CLASS_NAME);
        mapping.put(CssElementTypes.CSS_IDENT, IDENTIFIER);
        mapping.put(CssElementTypes.CSS_STRING_TOKEN, STRING);
        mapping.put(CssElementTypes.CSS_NUMBER, NUMBER);
        mapping.put(CssElementTypes.CSS_IMPORTANT, IMPORTANT);
        mapping.put(CssElementTypes.CSS_PROPERTY_NAME, PROPERTY_NAME);
        mapping.put(CssElementTypes.CSS_PROPERTY_VALUE, PROPERTY_VALUE);
        mapping.put(CssElementTypes.CSS_UNIT, UNIT);
        mapping.put(CssElementTypes.CSS_TAG_NAME, TAG_NAME);
        mapping.put(CssElementTypes.CSS_FUNCTION_TOKEN, FUNCTION);
        mapping.put(CssElementTypes.CSS_URI_START, FUNCTION);
        mapping.put(CssElementTypes.CSS_URL, URL);
        mapping.put(CssElementTypes.CSS_COLOR, COLOR);
        mapping.put(CssElementTypes.CSS_PSEUDO, PSEUDO);
        mapping.put(CssElementTypes.CSS_UNICODE_RANGE, UNICODE_RANGE);
        mapping.put(CssElementTypes.CSS_LPAREN, PARENTHESES);
        mapping.put(CssElementTypes.CSS_RPAREN, PARENTHESES);
        mapping.put(CssElementTypes.CSS_LBRACE, BRACES);
        mapping.put(CssElementTypes.CSS_RBRACE, BRACES);
        mapping.put(CssElementTypes.CSS_LBRACKET, BRACKETS);
        mapping.put(CssElementTypes.CSS_RBRACKET, BRACKETS);
        mapping.put(CssElementTypes.CSS_PERIOD, DOT);
        mapping.put(CssElementTypes.CSS_COLON, COLON);
        mapping.put(CssElementTypes.CSS_COMMA, COMMA);
        mapping.put(CssElementTypes.CSS_SEMICOLON, SEMICOLON);
        mapping.put(CssElementTypes.CSS_BAD_CHARACTER, BAD_CHARACTER);
        mapping.put(CssElementTypes.CSS_KEYWORD, KEYWORD);
        mapping.put(PostCssTokenTypes.AMPERSAND, AMPERSAND);
        for (IElementType type : PostCssTokenTypes.POST_CSS_COMMENTS.getTypes()) {
            mapping.put(type, COMMENT);
        }
        for (IElementType type : PostCssTokenTypes.KEYWORDS.getTypes()) {
            mapping.put(type, KEYWORD);
        }
        for (IElementType type : PostCssTokenTypes.IDENTIFIERS.getTypes()) {
            mapping.put(type, IDENTIFIER);
        }
        for (IElementType type : CssElementTypes.OPERATORS.getTypes()) {
            mapping.put(type, OPERATORS);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/postcss/highlighting/PostCssSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedTokenAttributes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

