/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServers.deployment.DeploymentProvider;
import com.intellij.javaee.appServers.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.descriptor.JavaeeAppDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeCmpDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.descriptor.JavaeeEjbDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeWebDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.JBossUtil;
import com.intellij.javaee.oss.jboss.descriptor.JBoss7AppDescriptor;
import com.intellij.javaee.oss.jboss.descriptor.JBoss7WebDescriptor;
import com.intellij.javaee.oss.jboss.model.JBoss7AppRoot;
import com.intellij.javaee.oss.jboss.model.JBoss7WebRoot;
import com.intellij.javaee.oss.jboss.model.JBossAppRoot;
import com.intellij.javaee.oss.jboss.model.JBossCmpRoot;
import com.intellij.javaee.oss.jboss.model.JBossEjbRoot;
import com.intellij.javaee.oss.jboss.model.JBossWebRoot;
import com.intellij.javaee.oss.jboss.server.JBossDeploymentProvider;
import com.intellij.javaee.oss.jboss.server.JBossServerHelper;
import com.intellij.javaee.oss.jboss.server.JBossServerVersionConfig;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.openapi.diagnostic.Logger;
import icons.JavaeeAppServersJbossBaseIcons;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBossIntegration
extends JavaeeIntegration
implements AppServerIntegration.WithLegacyServerSerialization {
    private static final Logger LOG = Logger.getInstance(JBossIntegration.class);

    public static JavaeeIntegration getInstance() {
        return (JavaeeIntegration)AppServerIntegrationsManager.getInstance().getIntegration(JBossIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = JBossBundle.getText("JBossIntegration.name", new Object[0]);
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getLegacyNameForServerSerialization() {
        String string = AppServersCommonBundle.getText((String)"Integration.name", (Object[])new Object[]{"JBoss"});
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaeeAppServersJbossBaseIcons.Jboss;
        if (icon == null) {
            JBossIntegration.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = JavaeeAppServersJbossBaseIcons.Jbossbig;
        if (icon == null) {
            JBossIntegration.$$$reportNull$$$0(3);
        }
        return icon;
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(JavaeeAppDescriptor.class, JBossAppRoot.class, "jboss-app");
        descriptorsManager.addItem(JavaeeEjbDescriptor.class, JBossEjbRoot.class, "jboss");
        descriptorsManager.addItem(JavaeeCmpDescriptor.class, JBossCmpRoot.class, "jbosscmp-jdbc");
        descriptorsManager.addItem(JavaeeWebDescriptor.class, JBossWebRoot.class, "jboss-web");
        @NonNls String deploymentStructureRootTagName = "jboss-deployment-structure";
        descriptorsManager.addItem(JBoss7AppDescriptor.class, JBoss7AppRoot.class, "jboss-deployment-structure");
        descriptorsManager.addItem(JBoss7WebDescriptor.class, JBoss7WebRoot.class, "jboss-deployment-structure");
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) {
        return template.split("_")[0];
    }

    @NonNls
    @NotNull
    public String getVersionFromTemplate(String template) {
        String string = template.replaceAll("[\\w-]+_(\\d+)_(\\d)\\.xml", "$1.$2");
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static JBossVersionHandler getVersionHandler(String home) {
        JBossVersionHandler[] versionHandlers;
        for (JBossVersionHandler versionHandler : versionHandlers = new JBossVersionHandler[]{new JBossVersion7Handler(home), new JBossVersion6Handler(home)}) {
            try {
                versionHandler.detect();
                return versionHandler;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData data) throws Exception {
        String string = JBossServerVersionConfig.get(data);
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) {
    }

    protected void addLibraryLocations(String home, List<Path> locations) {
        Path homePath = Path.of(home, new String[0]);
        locations.add(homePath.resolve("common/lib"));
        locations.add(homePath.resolve("lib"));
        Path serverPath = homePath.resolve("server");
        if (Files.exists(serverPath, new LinkOption[0])) {
            try (Stream<Path> serverDirs = Files.list(serverPath);){
                serverDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(server -> {
                    locations.add(server.resolve("lib"));
                    locations.add(server.resolve("deploy"));
                });
            }
            catch (IOException e) {
                LOG.warn("Failed to list server directories", (Throwable)e);
            }
        }
        locations.add(homePath.resolve("modules"));
    }

    @Nullable
    public String getContextRoot(JavaeeFacet facet) {
        JBossWebRoot web = JBossUtil.getWebRoot(facet);
        return web != null ? (String)web.getContextRoot().getValue() : null;
    }

    public boolean isKillOnDestroyWhileStarting() {
        return true;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JBossDeploymentProvider();
    }

    protected JavaeeServerHelper createServerHelper() {
        return new JBossServerHelper();
    }

    public ApplicationServerPersistentDataEditor<?> createNewServerEditor() {
        return new JavaeePersistentDataEditor((JavaeeIntegration)this);
    }

    public boolean isJreCustomizable() {
        return true;
    }

    @NotNull
    public String getFrameworkLibrariesDescriptionRemoteName() {
        return "jboss";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/oss/jboss/server/JBossIntegration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyNameForServerSerialization";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFromTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

