/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme;

import com.intellij.css.scheme.CssValueParsingUtil;
import com.intellij.css.scheme.CssValueSchemeGenerator;
import com.intellij.css.scheme.psi.CssValueFile;
import com.intellij.css.scheme.psi.Expression;
import com.intellij.css.scheme.psi.FuncCall;
import com.intellij.css.scheme.psi.Visitor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class CssW3SchemeGenerator {
    private String myVersion = "0";
    private final Map<String, Integer> myIndexes = new HashMap<String, Integer>();
    private final Tag mySeeTag = Tag.valueOf((String)"see");
    private String myBaseUrl = "";

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("url argument is missing");
            return;
        }
        String url = args[0];
        File file = new File(url);
        try (PrintStream outputStream = args.length > 1 ? new PrintStream(new FileOutputStream(args[1])) : System.out;
             InputStream inputStream = file.exists() ? new FileInputStream(file) : URLUtil.openStream((URL)new URL(url));){
            new CssW3SchemeGenerator().generateScheme(inputStream, outputStream);
        }
    }

    public CssW3SchemeGenerator() {
        try {
            Method setSelfClosing = this.mySeeTag.getClass().getDeclaredMethod("setSelfClosing", new Class[0]);
            setSelfClosing.setAccessible(true);
            setSelfClosing.invoke((Object)this.mySeeTag, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateScheme(InputStream inputStream, PrintStream out) throws IOException {
        Document document = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"");
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<!--");
        String title = CssW3SchemeGenerator.getTitle(document);
        this.myVersion = CssW3SchemeGenerator.parseVersion(title);
        out.println(title);
        out.println(CssW3SchemeGenerator.getSubtitle(document));
        Elements versions = CssW3SchemeGenerator.getVersionLinks(document);
        out.println(versions.first().attr("href"));
        this.myBaseUrl = ((Element)versions.get(1)).attr("href");
        out.println("-->");
        out.println("<definitions xmlns=\"urn:schemas-jetbrains-com:css-xml\">");
        this.generateNamedValues(document, out);
        this.generateProperties(document, out);
        this.generateMediaFeatures(document, out);
        out.println("</definitions>");
    }

    private static Elements getVersionLinks(Document document) {
        Elements links = document.getElementsByAttributeValue("data-fill-with", "spec-metadata").select("dl>dd>a");
        if (links.isEmpty()) {
            links = document.getElementsByTag("a");
        }
        return links;
    }

    private static String getSubtitle(Document document) {
        Element subtitleElement = document.getElementById("w3c-state");
        if (subtitleElement == null) {
            subtitleElement = document.getElementsByTag("h2").first();
        }
        return subtitleElement.text();
    }

    private static String getTitle(Document document) {
        Element titleElement = document.getElementById("title");
        if (titleElement == null) {
            titleElement = document.getElementsByTag("h1").first();
        }
        return titleElement.text();
    }

    private void generateMediaFeatures(Document document, PrintStream out) {
        this.processRows(CssW3SchemeGenerator.getMediaFeaturesTable(document), row -> this.generateMediaFeature((Element)row, out));
    }

    private void processRows(Elements tables, Consumer<Element> generator) {
        if (tables == null) {
            return;
        }
        int index = 0;
        Element tableHeading = tables.select("thead>tr").first();
        if (tableHeading == null) {
            return;
        }
        for (Element header : tableHeading.children()) {
            this.myIndexes.put(StringUtil.toLowerCase((String)header.text().replaceAll("[-\u00ad]", "")), index++);
        }
        for (Element row : tables.select("tbody>tr")) {
            generator.accept(row);
        }
    }

    private static Elements getMediaFeaturesTable(Document document) {
        Element mediaTable = document.getElementById("media-descriptor-table");
        Element element = mediaTable != null ? mediaTable.nextElementSibling() : null;
        return element != null ? element.select("table") : null;
    }

    private void generateMediaFeature(Element row, PrintStream out) {
        Elements columns = row.children();
        Element nameElement = this.getColumnValue(columns, "name");
        String mediaFeatureName = nameElement.text();
        mediaFeatureName = mediaFeatureName.trim();
        Object anchor = nameElement.getElementsByTag("a").first().attr("href");
        if (!((String)anchor).startsWith("#")) {
            anchor = "#" + mediaFeatureName;
        }
        out.print("<media-feature id=\"" + mediaFeatureName + "\"");
        out.print(" declared-in=\"" + this.myVersion + "\"");
        out.print(" url=\"" + this.myBaseUrl + (String)anchor + "\"");
        out.print(" min-max=\"" + ("range".equals(this.getColumnValue(columns, "type").text()) ? "yes" : "no") + "\"");
        out.println(">");
        Element mediaFeatureElement = CssW3SchemeGenerator.getMediaFeatureElement(mediaFeatureName, (String)anchor, row.ownerDocument());
        Element next = mediaFeatureElement.nextElementSibling();
        if (next != null) {
            Element descriptionElement = mediaFeatureElement.hasClass("descdef") ? next : next.nextElementSibling();
            Element element = descriptionElement = descriptionElement.hasClass("advisement") ? descriptionElement.nextElementSibling() : descriptionElement;
            if (descriptionElement != null && "p".equalsIgnoreCase(descriptionElement.tagName())) {
                String description = this.extractAndSanitizeDescription(mediaFeatureName, descriptionElement);
                out.println("<description><![CDATA[" + description + "]]></description>");
            }
        }
        Map<String, String> valueTooltips = CssW3SchemeGenerator.collectValueTooltips(mediaFeatureName, mediaFeatureElement);
        CssW3SchemeGenerator.generateValues(this.getColumnValue(columns, "value").text(), valueTooltips, null, out, false);
        out.println("</media-feature>\n");
    }

    private void generateProperties(Document document, PrintStream out) {
        this.processRows(CssW3SchemeGenerator.getPropertiesTable(document), row -> this.generateProperty((Element)row, out));
    }

    private static Elements getPropertiesTable(Document document) {
        Elements propertiesTable;
        Element propertyIndex = document.getElementById("property-index");
        Elements elements = propertiesTable = propertyIndex != null ? propertyIndex.nextElementSibling().select("table") : new Elements();
        if (propertiesTable.isEmpty()) {
            propertiesTable = document.select("#property-index ~ table");
        }
        return propertiesTable;
    }

    private void generateProperty(Element row, PrintStream out) {
        Elements columns = row.children();
        Element nameElement = this.getColumnValue(columns, "name", "property");
        List split = StringUtil.split((String)nameElement.text(), (String)",");
        for (int i = 0; i < split.size(); ++i) {
            Element animatable;
            String propertyName = (String)split.get(i);
            propertyName = propertyName.trim();
            Object anchor = ((Element)nameElement.getElementsByTag("a").get(i)).attr("href");
            if (!((String)anchor).startsWith("#")) {
                anchor = "#" + propertyName;
            }
            out.print("<property id=\"" + propertyName + "\"");
            out.print(" declared-in=\"" + this.myVersion + "\"");
            out.print(" url=\"" + this.myBaseUrl + (String)anchor + "\"");
            out.print(" applies=\"" + this.getColumnValue(columns, "applies").text() + "\"");
            String inheritedValue = this.getColumnValue(columns, "inherited", "inh").text();
            String initial = this.getColumnValue(columns, "initial").text();
            if (!initial.isEmpty()) {
                out.print(" initial=\"" + initial + "\"");
            }
            out.print(" inherited=\"" + ("no".equals(inheritedValue) ? "no" : "yes") + "\"");
            out.print(" percentage=\"" + this.getColumnValue(columns, "percentage", "%ages", "%").text() + "\"");
            String media = this.getColumnValue(columns, "media").text();
            if ("see individual properties".equals(media)) {
                media = "TODO";
            }
            if (!media.isEmpty() && !"all".equals(media)) {
                out.print(" media=\"" + media + "\"");
            }
            if ((animatable = this.getColumnValue(columns, "animatable")) != null && !animatable.text().isEmpty()) {
                out.print(" animatable=\"" + ("no".equalsIgnoreCase(animatable.text()) ? "no" : "yes") + "\"");
            }
            out.println(">");
            Element propertyElement = CssW3SchemeGenerator.getPropertyElement(propertyName, (String)anchor, row.ownerDocument());
            Element next = propertyElement.nextElementSibling();
            if (next != null) {
                Element descriptionElement = propertyElement.hasClass("propdef") ? next : next.nextElementSibling();
                Element element = descriptionElement = descriptionElement != null && descriptionElement.hasClass("advisement") ? descriptionElement.nextElementSibling() : descriptionElement;
                if (descriptionElement != null && "p".equalsIgnoreCase(descriptionElement.tagName())) {
                    String description = this.extractAndSanitizeDescription(propertyName, descriptionElement);
                    out.println("<description><![CDATA[" + description + "]]></description>");
                }
            }
            Map<String, String> valueTooltips = CssW3SchemeGenerator.collectValueTooltips(propertyName, propertyElement);
            CssW3SchemeGenerator.generateValues(this.getColumnValue(columns, "value").text(), valueTooltips, null, out, true);
            out.println("</property>\n");
        }
    }

    @NotNull
    private static Map<String, String> collectValueTooltips(String propertyName, Element propertyElement) {
        HashMap<String, String> valueTooltips = new HashMap<String, String>();
        Elements valueDescriptionElements = CssW3SchemeGenerator.getValueDescriptionsElements(propertyName, propertyElement);
        for (Element element : valueDescriptionElements) {
            Elements dts = "dfn".equalsIgnoreCase(element.tag().getName()) ? element.parent().parent().select("dt") : element.select("dt");
            Iterator iterator = dts.iterator();
            while (iterator.hasNext()) {
                Element dt;
                HashSet<String> keys = new HashSet<String>();
                for (dt = (Element)iterator.next(); dt != null && dt.tagName().equalsIgnoreCase("dt"); dt = dt.nextElementSibling()) {
                    keys.add(dt.text());
                }
                if (dt == null || !dt.tagName().equalsIgnoreCase("dd")) continue;
                for (String key : keys) {
                    valueTooltips.put(key, XmlStringUtil.escapeString((String)XmlStringUtil.stripHtml((String)dt.text())));
                }
            }
        }
        HashMap<String, String> hashMap = valueTooltips;
        if (hashMap == null) {
            CssW3SchemeGenerator.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    private static Element getMediaFeatureElement(String mediaFeatureName, String anchor, Document document) {
        Element element = document.getElementById(mediaFeatureName);
        if (element == null) {
            element = document.getElementById("descdef-media-" + mediaFeatureName);
        }
        if (element == null) {
            element = document.getElementById(anchor.substring(1));
        }
        if (element != null && "dfn".equalsIgnoreCase(element.tagName())) {
            return element.parent().parent().parent().parent();
        }
        return element;
    }

    private static Element getPropertyElement(String propertyName, String anchor, Document document) {
        Element element = document.getElementById(propertyName);
        if (element == null) {
            element = document.getElementById("propdef-" + propertyName);
        }
        if (element == null) {
            element = document.getElementById(anchor.substring(1));
        }
        if (element != null && "dfn".equalsIgnoreCase(element.tagName())) {
            return element.parent().parent().parent().parent();
        }
        return element;
    }

    private static Elements getValueDescriptionsElements(String propertyName, Element propertyElement) {
        Elements elements = propertyElement.ownerDocument().getElementsByAttributeValueContaining("data-dfn-for", propertyName);
        if (!elements.isEmpty()) {
            return elements;
        }
        elements = propertyElement.getElementsByTag("dl");
        if (!elements.isEmpty()) {
            return elements;
        }
        Element next = propertyElement;
        HashSet tagsToSkip = ContainerUtil.newHashSet((Object[])new String[]{"div", "p", "table", "h5"});
        Elements result = new Elements();
        while ((next = next.nextElementSibling()) != null) {
            String tagName = next.tagName();
            if ("dl".equalsIgnoreCase(tagName)) {
                result.add((Object)next);
                continue;
            }
            if (tagsToSkip.contains(tagName)) continue;
            break;
        }
        return result;
    }

    private String extractAndSanitizeDescription(String propertyName, Element element) {
        for (Element link : element.getElementsByTag("a")) {
            if ("property".equalsIgnoreCase(link.className()) && !propertyName.equalsIgnoreCase(link.text())) {
                Attributes attributes = new Attributes();
                attributes.put("cref", "P:" + link.text());
                link.replaceWith((Node)new Element(this.mySeeTag, link.baseUri(), attributes));
                continue;
            }
            link.replaceWith((Node)TextNode.createFromEncoded((String)link.text()));
        }
        for (Element dfn : element.getElementsByTag("dfn")) {
            Element strong = new Element(Tag.valueOf((String)"strong"), dfn.baseUri());
            strong.text(dfn.text());
            dfn.replaceWith((Node)strong);
        }
        return element.toString();
    }

    private void generateNamedValues(Document document, final PrintStream out) {
        for (Element namedElement : document.select("[id^=typedef-]")) {
            String text = namedElement.text();
            final String name = text.substring(1, text.length() - 1).trim();
            if (CssValueSchemeGenerator.KNOWN_VALUE_TAGS.contains(name)) continue;
            String valueText = CssW3SchemeGenerator.getNamedValueText(namedElement);
            CssValueFile valueFile = CssValueParsingUtil.parseFile(valueText);
            valueFile.acceptChildren(new Visitor(){

                @Override
                public void visitFuncCall(@NotNull FuncCall o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitFuncCall(o);
                    Expression expression = o.getExpression();
                    if (expression != null) {
                        String functionName = o.getFirstChild().getText();
                        String newFunctionName = functionName + "-" + name;
                        out.println("<function id=\"" + newFunctionName + "\" declared-in=\"" + CssW3SchemeGenerator.this.myVersion + "\">");
                        CssW3SchemeGenerator.generateValues(expression.getText(), Collections.emptyMap(), null, out, false);
                        out.println("</function>");
                    }
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitElement(element);
                    element.acceptChildren((PsiElementVisitor)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "o";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/css/scheme/CssW3SchemeGenerator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitFuncCall";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.generateNamedValue(out, namedElement, name, () -> CssW3SchemeGenerator.generateValues(valueFile, CssW3SchemeGenerator.collectValueTooltips(name, namedElement), name, out, false));
            for (String additionalName : StringUtil.split((String)namedElement.attr("data-dfn-for"), (String)",")) {
                String trimmedName = additionalName.trim();
                this.generateNamedValue(out, namedElement, trimmedName, () -> out.println("<inline id=\"" + name + "\" inline=\"yes\"/>"));
            }
        }
    }

    private void generateNamedValue(PrintStream out, Element namedElement, String id, Runnable generateValue) {
        out.print("<named-value id=\"" + id + "\"");
        out.print(" declared-in=\"" + this.myVersion + "\"");
        out.println(" url=\"" + this.myBaseUrl + "#" + namedElement.id() + "\">");
        generateValue.run();
        out.println("</named-value>\n");
    }

    private static String getNamedValueText(Element element) {
        StringBuilder valueText = new StringBuilder();
        for (Node sibling = element.nextSibling(); !(sibling == null || sibling instanceof Element && ((Element)sibling).id().startsWith("typedef-")); sibling = sibling.nextSibling()) {
            if (sibling instanceof Element) {
                valueText.append(((Element)sibling).text().trim());
                continue;
            }
            valueText.append(sibling.outerHtml().trim());
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.unescapeXmlEntities((String)valueText.toString()).trim(), (String)"="), (String)";");
    }

    private static void generateValues(String valueString, Map<String, String> valueTooltips, String functionsSuffix, PrintStream out, boolean wideKeywords) {
        CssW3SchemeGenerator.generateValues(CssValueParsingUtil.parseFile(valueString), valueTooltips, functionsSuffix, out, wideKeywords);
    }

    private static void generateValues(CssValueFile file, Map<String, String> valueTooltips, String functionsSuffix, PrintStream out, boolean wideKeywords) {
        out.print(new CssValueSchemeGenerator(wideKeywords, functionsSuffix).generate(file, valueTooltips));
    }

    private static String parseVersion(@NotNull String title) {
        if (title == null) {
            CssW3SchemeGenerator.$$$reportNull$$$0(1);
        }
        return switch (title.charAt(title.length() - 1)) {
            case '2' -> "2.1";
            case '3' -> "3.0";
            case '4' -> "4.0";
            default -> "0";
        };
    }

    private Element getColumnValue(Elements columns, String ... columnNames) {
        for (String name : columnNames) {
            Integer index = this.myIndexes.get(StringUtil.toLowerCase((String)name));
            if (index == null) continue;
            return (Element)columns.get(index.intValue());
        }
        for (String columnName : columnNames) {
            for (Map.Entry<String, Integer> entry : this.myIndexes.entrySet()) {
                if (!StringUtil.containsIgnoreCase((String)entry.getKey(), (String)columnName)) continue;
                return (Element)columns.get(entry.getValue().intValue());
            }
        }
        return new Element(Tag.valueOf((String)"empty"), "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/css/scheme/CssW3SchemeGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValueTooltips";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/css/scheme/CssW3SchemeGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

