/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.google.gson.Gson;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSCodeStyleUtil;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigKt;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRulesKt;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0015\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0015\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper;", "", "rules", "", "", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "extends", "", "<init>", "(Ljava/util/Map;Ljava/util/List;)V", "hasExtends", "", "getOption", "name", "getRulesToApply", "", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintRule;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Lorg/jetbrains/annotations/NotNull;", "language", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "settings", "custom", "Lcom/intellij/lang/typescript/formatter/TypeScriptCodeStyleSettings;", "applyRules", "", "Companion", "intellij.tslint"})
@SourceDebugExtension(value={"SMAP\nTsLintConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TsLintConfig.kt\ncom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n774#2:193\n865#2,2:194\n1869#2,2:196\n*S KotlinDebug\n*F\n+ 1 TsLintConfig.kt\ncom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper\n*L\n31#1:193\n31#1:194,2\n46#1:196,2\n*E\n"})
public final class TsLintConfigWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TslintJsonOption> rules;
    @NotNull
    private final List<String> extends;
    @NotNull
    private static final Key<ParameterizedCachedValue<TsLintConfigWrapper, PsiFile>> RULES_CACHE_KEY;
    @NotNull
    private static final ParameterizedCachedValueProvider<TsLintConfigWrapper, PsiFile> CACHED_VALUE_PROVIDER;

    public TsLintConfigWrapper(@NotNull Map<String, TslintJsonOption> rules, @NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter(list, (String)"extends");
        this.rules = rules;
        this.extends = list;
    }

    public final boolean hasExtends() {
        return !((Collection)this.extends).isEmpty();
    }

    private final TslintJsonOption getOption(String name) {
        return this.rules.get(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<TsLintRule> getRulesToApply(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CodeStyleSettings settings = this.current(project);
        CommonCodeStyleSettings languageSettings = this.language(settings);
        TypeScriptCodeStyleSettings jsCodeStyleSettings = this.custom(settings);
        Iterable $this$filter$iv = TsLintRulesKt.getTslintRulesSet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TsLintRule it = (TsLintRule)element$iv$iv;
            boolean bl = false;
            TslintJsonOption option = this.getOption(it.getOptionId());
            if (!(option != null && option.isEnabled() && it.isAvailable(languageSettings, (JSCodeStyleSettings)jsCodeStyleSettings, option))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CodeStyleSettings current(Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        return codeStyleSettings;
    }

    private final CommonCodeStyleSettings language(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)JavaScriptSupportLoader.TYPESCRIPT);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        return commonCodeStyleSettings;
    }

    private final TypeScriptCodeStyleSettings custom(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(TypeScriptCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        return (TypeScriptCodeStyleSettings)customCodeStyleSettings;
    }

    public final void applyRules(@NotNull Project project, @NotNull Collection<? extends TsLintRule> rules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        JSCodeStyleUtil.updateProjectCodeStyle((Project)project, arg_0 -> TsLintConfigWrapper.applyRules$lambda$1(arg_0 -> TsLintConfigWrapper.applyRules$lambda$0(this, rules, arg_0), arg_0));
    }

    private static final Unit applyRules$lambda$0(TsLintConfigWrapper this$0, Collection $rules, CodeStyleSettings newSettings) {
        WriteAction.run(() -> TsLintConfigWrapper.applyRules$lambda$0$0(this$0, newSettings, $rules));
        return Unit.INSTANCE;
    }

    private static final void applyRules$lambda$0$0(TsLintConfigWrapper this$0, CodeStyleSettings $newSettings, Collection $rules) {
        Intrinsics.checkNotNull((Object)$newSettings);
        CommonCodeStyleSettings newLanguageSettings = this$0.language($newSettings);
        TypeScriptCodeStyleSettings newJsCodeStyleSettings = this$0.custom($newSettings);
        Iterable $this$forEach$iv = $rules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TsLintRule it = (TsLintRule)element$iv;
            boolean bl = false;
            TslintJsonOption option = this$0.getOption(it.getOptionId());
            if (option == null) continue;
            it.apply(newLanguageSettings, (JSCodeStyleSettings)newJsCodeStyleSettings, option);
        }
    }

    private static final void applyRules$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result CACHED_VALUE_PROVIDER$lambda$0(PsiFile it) {
        Object[] objectArray;
        if (it == null || PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it))) {
            objectArray = new Object[]{it};
            CachedValueProvider.Result.create(null, (Object[])objectArray);
        }
        objectArray = new Object[]{it};
        return CachedValueProvider.Result.create((Object)Companion.getConfigFromText(it.getText()), (Object[])objectArray);
    }

    static {
        Key key = Key.create((String)"tslint.cache.key.config.json");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RULES_CACHE_KEY = key;
        CACHED_VALUE_PROVIDER = TsLintConfigWrapper::CACHED_VALUE_PROVIDER$lambda$0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J \u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper$Companion;", "", "<init>", "()V", "RULES_CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/ParameterizedCachedValue;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper;", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "CACHED_VALUE_PROVIDER", "Lcom/intellij/psi/util/ParameterizedCachedValueProvider;", "getConfigForFile", "psiFile", "getConfigFromText", "text", "", "jsonAsMap", "", "yamlAsMap", "intellij.tslint"})
    @SourceDebugExtension(value={"SMAP\nTsLintConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TsLintConfig.kt\ncom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n463#2:193\n413#2:194\n1252#3,4:195\n*S KotlinDebug\n*F\n+ 1 TsLintConfig.kt\ncom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper$Companion\n*L\n79#1:193\n79#1:194\n79#1:195,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TsLintConfigWrapper getConfigForFile(@Nullable PsiFile psiFile) {
            if (psiFile == null) {
                return null;
            }
            TsLintConfigWrapper tsLintConfigWrapper = (TsLintConfigWrapper)CachedValuesManager.getManager((Project)psiFile.getProject()).getParameterizedCachedValue((UserDataHolder)psiFile, RULES_CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)psiFile);
            if (tsLintConfigWrapper == null) {
                return null;
            }
            return tsLintConfigWrapper;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TsLintConfigWrapper getConfigFromText(@Nullable String text) {
            Object rulesObject;
            Map<String, Object> map;
            Map<String, Object> map2 = this.jsonAsMap(text);
            if (map2 == null) {
                map2 = this.yamlAsMap(text);
            }
            if ((map = map2) != null && (rulesObject = map.get("rules")) instanceof Map) {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                Map typed;
                Map $this$mapValues$iv = typed = (Map)rulesObject;
                boolean $i$f$mapValues = false;
                Map map3 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map4 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map5 = map4;
                    boolean bl2 = false;
                    TslintJsonOption tslintJsonOption = new TslintJsonOption(it.getValue());
                    map5.put(k, tslintJsonOption);
                }
                List list = TsLintConfigKt.access$asStringArrayOrSingleString(map.get("extends"));
                Map map6 = destination$iv$iv$iv;
                return new TsLintConfigWrapper(map6, list);
            }
            return null;
        }

        private final Map<String, Object> jsonAsMap(String text) {
            Map map;
            try {
                map = (Map)new Gson().fromJson(text, (Type)((Object)Map.class));
            }
            catch (Exception e) {
                TsLintConfigKt.access$getLOG$p().debug("Could not parse JSON TSLint config from " + text, (Throwable)e);
                map = null;
            }
            return map;
        }

        private final Map<String, Object> yamlAsMap(String text) {
            Map map;
            try {
                map = (Map)new Yaml().load(text);
            }
            catch (Exception e) {
                TsLintConfigKt.access$getLOG$p().debug("Could not parse YAML TSLint config from " + text, (Throwable)e);
                map = null;
            }
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

