/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceProviderType;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.resolve.CssFileReferenceProvider;
import com.intellij.psi.css.resolve.StylesheetFileReferenceSet;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssReferenceProviderUtil {
    public static final ReferenceProviderType CSS_CLASS_OR_ID_KEY_PROVIDER = new ReferenceProviderType("Css Class or ID Provider");

    public static PsiReference @NotNull [] getFileReferences(@Nullable PsiElement element, boolean typedReference, boolean isImageReference, FileType ... suitableFileTypes) {
        return CssReferenceProviderUtil.getFileReferences(element, typedReference, isImageReference, false, suitableFileTypes);
    }

    public static PsiReference @NotNull [] getFileReferences(@Nullable PsiElement element, boolean typedReference, boolean isImageReference, boolean isFontReference, FileType ... suitableFileTypes) {
        Pair<String, TextRange> referenceData;
        if (element != null) {
            for (CssFileReferenceProvider provider : CssFileReferenceProvider.Companion.getEP().getExtensionList()) {
                PsiReference[] references = provider.getFileReferences(element);
                if (references == null) continue;
                if (references == null) {
                    CssReferenceProviderUtil.$$$reportNull$$$0(0);
                }
                return references;
            }
        }
        if ((referenceData = CssReferenceProviderUtil.getFileReferenceData(element)) != null) {
            if (HtmlUtil.hasHtmlPrefix((String)((String)referenceData.first))) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new UrlReference(element, (FileType)(typedReference ? CssFileType.INSTANCE : null), !typedReference)};
                if (psiReferenceArray == null) {
                    CssReferenceProviderUtil.$$$reportNull$$$0(1);
                }
                return psiReferenceArray;
            }
            StylesheetFileReferenceSet referenceSet = new StylesheetFileReferenceSet(element, (String)referenceData.first, (TextRange)referenceData.second, isImageReference, isFontReference, suitableFileTypes);
            FileReference[] fileReferenceArray = referenceSet.getAllReferences();
            if (fileReferenceArray == null) {
                CssReferenceProviderUtil.$$$reportNull$$$0(2);
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            CssReferenceProviderUtil.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public static Pair<String, TextRange> getFileReferenceData(@Nullable PsiElement element) {
        TextRange resultRange;
        String resultText;
        int lastPosOfURL;
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)parent))) {
            return null;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        String elementText = element.getText();
        if (URLUtil.isDataUri((String)elementText)) {
            return null;
        }
        int indexOfBang = elementText.lastIndexOf(33, endOffset);
        if (indexOfBang >= 0 && startOffset <= indexOfBang && indexOfBang < endOffset) {
            startOffset = indexOfBang + 1;
        }
        if (elementText.startsWith("CSS:", startOffset)) {
            startOffset += 4;
        }
        if ((lastPosOfURL = PathReferenceProviderBase.getLastPosOfURL((int)startOffset, (String)elementText)) == startOffset) {
            return null;
        }
        int n = endOffset = lastPosOfURL >= 0 ? lastPosOfURL : endOffset;
        if (element instanceof CssString) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                IElementType type = child.getNode().getElementType();
                if (type == CssElementTypes.CSS_STRING_TOKEN) continue;
                if (lastPosOfURL != -1 && lastPosOfURL < child.getStartOffsetInParent()) break;
                return null;
            }
        }
        if (startOffset > endOffset) {
            return null;
        }
        int indexOfNewLine = elementText.indexOf(10, startOffset);
        if (indexOfNewLine > -1) {
            endOffset = indexOfNewLine;
        }
        if (CssReferenceProviderUtil.isDataUrl(resultText = (resultRange = TextRange.create((int)startOffset, (int)endOffset)).substring(elementText))) {
            return null;
        }
        return Pair.create((Object)resultText, (Object)resultRange);
    }

    private static boolean isDataUrl(@NotNull String string) {
        if (string == null) {
            CssReferenceProviderUtil.$$$reportNull$$$0(4);
        }
        return string.startsWith("data:");
    }

    private CssReferenceProviderUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssReferenceProviderUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssReferenceProviderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDataUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

