/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;

public class ELMethodSignature {
    private final String myReturnType;
    private final ArrayList<String> myParameters;
    private final int myParamStartIndex;
    private final String mySignature;

    public ELMethodSignature(String signature) {
        this.mySignature = signature;
        int endIndex = signature.indexOf(32);
        int correctedEndIndex = endIndex != -1 ? endIndex : signature.length();
        this.myReturnType = signature.substring(0, correctedEndIndex);
        this.myParameters = new ArrayList(1);
        this.myParamStartIndex = signature.indexOf(40, correctedEndIndex);
        if (this.myParamStartIndex != -1) {
            int paramEndIndex = signature.indexOf(41, this.myParamStartIndex);
            int correctedParamEndIndex = paramEndIndex != -1 ? paramEndIndex : signature.length();
            String paramString = signature.substring(this.myParamStartIndex + 1, correctedParamEndIndex);
            StringTokenizer tokenizer = new StringTokenizer(paramString, " \t,");
            while (tokenizer.hasMoreElements()) {
                this.myParameters.add(tokenizer.nextToken());
            }
        }
    }

    @Nullable
    public String getSignatureForMethodName(String name) {
        if (this.myParamStartIndex == -1 || this.myReturnType == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("public ").append(this.myReturnType).append(' ').append(name).append('(');
        int myParametersSize = this.myParameters.size();
        for (int i = 0; i < myParametersSize; ++i) {
            String parameter = this.myParameters.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameter).append(" p").append(i);
        }
        builder.append(')');
        return builder.toString();
    }

    public String getReturnType() {
        return this.myReturnType;
    }

    public ArrayList<String> getParameters() {
        return this.myParameters;
    }

    public String getSignature() {
        return this.mySignature;
    }
}

