/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyAccessorDetector;
import com.intellij.psi.util.PropertyUtilBase;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokPropertyAccessorDetector
implements PropertyAccessorDetector {
    @Nullable
    public PropertyAccessorDetector.PropertyAccessorInfo detectPropertyAccessor(@NotNull PsiMethod method) {
        LombokLightMethodBuilder methodBuilder;
        PsiElement navigationElement;
        if (method == null) {
            LombokPropertyAccessorDetector.$$$reportNull$$$0(0);
        }
        if (method instanceof LombokLightMethodBuilder && (navigationElement = (methodBuilder = (LombokLightMethodBuilder)method).getNavigationElement()) instanceof PsiField) {
            PsiField originalField = (PsiField)navigationElement;
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(originalField);
            boolean lombokPropertySetterOrWither = LombokPropertyAccessorDetector.isLombokPropertySetterOrWither(methodBuilder, originalField, accessorsInfo);
            boolean lombokPropertyGetter = LombokPropertyAccessorDetector.isLombokPropertyGetter(methodBuilder, originalField, accessorsInfo);
            if (lombokPropertySetterOrWither || lombokPropertyGetter) {
                return new PropertyAccessorDetector.PropertyAccessorInfo(PropertyUtilBase.suggestPropertyName((PsiField)originalField), originalField.getType(), lombokPropertyGetter ? PropertyKind.GETTER : PropertyKind.SETTER);
            }
        }
        return null;
    }

    private static boolean isLombokPropertyGetter(LombokLightMethodBuilder method, PsiField originalField, AccessorsInfo accessorsInfo) {
        return !method.hasParameters() && method.getName().equals(LombokUtils.getGetterName(originalField, accessorsInfo));
    }

    private static boolean isLombokPropertySetterOrWither(LombokLightMethodBuilder method, PsiField originalField, AccessorsInfo accessorsInfo) {
        return method.getParameterList().getParameters().length == 1 && (method.getName().equals(LombokUtils.getSetterName(originalField, accessorsInfo)) || method.getName().equals(LombokUtils.getWitherName((PsiVariable)originalField, accessorsInfo)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "de/plushnikov/intellij/plugin/extension/LombokPropertyAccessorDetector", "detectPropertyAccessor"));
    }
}

