/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.psi.LombokDelegateMethod;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DelegateHandler {
    private static final String TYPES_PARAMETER = "types";
    private static final String EXCLUDES_PARAMETER = "excludes";

    public static boolean validate(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull PsiType delegateTargetType, @NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink problemSink) {
        if (psiModifierListOwner == null) {
            DelegateHandler.$$$reportNull$$$0(0);
        }
        if (delegateTargetType == null) {
            DelegateHandler.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(2);
        }
        if (problemSink == null) {
            DelegateHandler.$$$reportNull$$$0(3);
        }
        boolean result = true;
        if (psiModifierListOwner.hasModifierProperty("static")) {
            problemSink.addErrorMessage("inspection.message.delegate.legal.only.on.instance.fields", new Object[0]);
            result = false;
        }
        Collection<PsiType> types = DelegateHandler.collectDelegateTypes(psiAnnotation, delegateTargetType);
        result &= DelegateHandler.validateTypes(types, problemSink);
        result &= DelegateHandler.validateTypesMethodsExistsInDelegateTargetType(types, delegateTargetType, problemSink);
        Collection<PsiType> excludes = DelegateHandler.collectExcludeTypes(psiAnnotation);
        result &= DelegateHandler.validateTypes(excludes, problemSink);
        return result &= DelegateHandler.validateTypesMethodsExistsInDelegateTargetType(excludes, delegateTargetType, problemSink);
    }

    private static boolean validateTypesMethodsExistsInDelegateTargetType(@NotNull Collection<PsiType> types, @NotNull PsiType delegateTargetType, @NotNull ProblemSink sink) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiDelegateTargetClass;
        if (types == null) {
            DelegateHandler.$$$reportNull$$$0(4);
        }
        if (delegateTargetType == null) {
            DelegateHandler.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            DelegateHandler.$$$reportNull$$$0(6);
        }
        boolean result = true;
        HashSet<PsiType> typesToCheck = new HashSet<PsiType>(types);
        typesToCheck.remove(delegateTargetType);
        if (!typesToCheck.isEmpty() && null != (psiDelegateTargetClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)delegateTargetType)).getElement())) {
            List delegateTargetSignatures = ContainerUtil.map((Collection)psiDelegateTargetClass.getVisibleSignatures(), signature -> MethodSignatureBackedByPsiMethod.create((PsiMethod)signature.getMethod(), (PsiSubstitutor)resolveResult.getSubstitutor()));
            ArrayList<HierarchicalMethodSignature> invalidMethodSignature = new ArrayList<HierarchicalMethodSignature>();
            for (PsiType psiType : typesToCheck) {
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
                if (null == psiClass) continue;
                Collection methodSignatures = psiClass.getVisibleSignatures();
                for (HierarchicalMethodSignature methodSignature : methodSignatures) {
                    MethodSignatureBackedByPsiMethod matchingSignature = (MethodSignatureBackedByPsiMethod)ContainerUtil.find((Iterable)delegateTargetSignatures, signature -> MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)signature, (MethodSignature)methodSignature));
                    if (matchingSignature != null) continue;
                    invalidMethodSignature.add(methodSignature);
                }
            }
            if (!invalidMethodSignature.isEmpty()) {
                String invalidMethodNames = (String)invalidMethodSignature.stream().map(MethodSignatureBackedByPsiMethod::getName).map(n -> "'%s'".formatted(n)).collect(NlsMessages.joiningAnd());
                Supplier[] fixes = (Supplier[])invalidMethodSignature.stream().map(MethodSignatureBackedByPsiMethod::getMethod).map(method -> () -> LocalQuickFix.from((ModCommandAction)new DeleteElementFix((PsiElement)method, CommonQuickFixBundle.message((String)"fix.remove.title.x", (Object[])new Object[]{JavaElementKind.METHOD.object(), method.getName()})))).toArray(Supplier[]::new);
                sink.addWarningMessage("inspection.message.delegate.unknown.type.method", invalidMethodSignature.size(), invalidMethodNames).withLocalQuickFixes(fixes);
            }
        }
        return result;
    }

    private static Collection<PsiType> collectDelegateTypes(PsiAnnotation psiAnnotation, PsiType psiType) {
        Collection<PsiType> types = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, TYPES_PARAMETER, PsiType.class, List.of());
        if (types.isEmpty()) {
            types = Collections.singletonList(psiType);
        }
        return types;
    }

    private static boolean validateTypes(Collection<PsiType> psiTypes, ProblemSink problemSink) {
        boolean result = true;
        for (PsiType psiType : psiTypes) {
            if (!DelegateHandler.checkConcreteClass(psiType)) {
                problemSink.addErrorMessage("inspection.message.delegate.can.only.use.concrete.class.types", psiType.getCanonicalText());
                result = false;
                continue;
            }
            result &= DelegateHandler.validateRecursion(psiType, problemSink);
        }
        return result;
    }

    private static boolean validateRecursion(PsiType psiType, ProblemSink problemSink) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        if (null != psiClass) {
            DelegateAnnotationElementVisitor delegateAnnotationElementVisitor = new DelegateAnnotationElementVisitor(psiType, problemSink);
            psiClass.acceptChildren((PsiElementVisitor)delegateAnnotationElementVisitor);
            return delegateAnnotationElementVisitor.isValid();
        }
        return true;
    }

    private static boolean checkConcreteClass(@NotNull PsiType psiType) {
        if (psiType == null) {
            DelegateHandler.$$$reportNull$$$0(7);
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return !(psiClass instanceof PsiTypeParameter);
        }
        return false;
    }

    private static Collection<PsiType> collectExcludeTypes(PsiAnnotation psiAnnotation) {
        return PsiAnnotationUtil.getAnnotationValues(psiAnnotation, EXCLUDES_PARAMETER, PsiType.class, List.of());
    }

    public static <T extends PsiMember & PsiNamedElement> void generateElements(@NotNull T psiElement, @NotNull PsiType delegateTargetType, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        PsiClass psiClass;
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(8);
        }
        if (delegateTargetType == null) {
            DelegateHandler.$$$reportNull$$$0(9);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(10);
        }
        if (target == null) {
            DelegateHandler.$$$reportNull$$$0(11);
        }
        if (!((psiClass = psiElement.getContainingClass()) instanceof PsiExtensibleClass)) {
            return;
        }
        PsiExtensibleClass containingPsiClass = (PsiExtensibleClass)psiClass;
        Collection<PsiType> includes = DelegateHandler.collectDelegateTypes(psiAnnotation, delegateTargetType);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> includesMethods = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (PsiType psiType : includes) {
            DelegateHandler.addMethodsOfType(psiType, includesMethods);
        }
        Collection<PsiType> excludes = DelegateHandler.collectExcludeTypes(psiAnnotation);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> excludeMethods = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (PsiType psiType : excludes) {
            DelegateHandler.addMethodsOfType(psiType, excludeMethods);
        }
        DelegateHandler.collectAllOwnMethods(containingPsiClass, excludeMethods);
        Collection<Pair<PsiMethod, PsiSubstitutor>> methodsToDelegate = DelegateHandler.findMethodsToDelegate(includesMethods, excludeMethods);
        for (Pair<PsiMethod, PsiSubstitutor> pair : methodsToDelegate) {
            target.add((PsiElement)DelegateHandler.generateDelegateMethod((PsiClass)containingPsiClass, psiElement, psiAnnotation, (PsiMethod)pair.getFirst(), (PsiSubstitutor)pair.getSecond()));
        }
    }

    private static void addMethodsOfType(PsiType psiType, Collection<Pair<PsiMethod, PsiSubstitutor>> results) {
        if (!(psiType instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (null != psiClass) {
            PsiSubstitutor classResolveResultSubstitutor = classResolveResult.getSubstitutor();
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiSubstitutor psiSubstitutor;
                PsiClass containingClass;
                if (!DelegateHandler.isAcceptableMethod(psiMethod) || (containingClass = psiMethod.getContainingClass()) == null || DelegateHandler.isAlreadyPresent(psiMethod, psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)classResolveResultSubstitutor), results)) continue;
                results.add((Pair<PsiMethod, PsiSubstitutor>)Pair.pair((Object)psiMethod, (Object)psiSubstitutor));
            }
        }
    }

    private static void collectAllOwnMethods(@NotNull PsiExtensibleClass psiStartClass, Collection<Pair<PsiMethod, PsiSubstitutor>> results) {
        PsiExtensibleClass psiExtensibleSuperClass;
        PsiClass psiClass;
        if (psiStartClass == null) {
            DelegateHandler.$$$reportNull$$$0(12);
        }
        Object psiClass2 = psiStartClass;
        do {
            for (PsiMethod psiMethod : psiClass2.getOwnMethods()) {
                if (!DelegateHandler.isAcceptableMethod(psiMethod) || DelegateHandler.isAlreadyPresent(psiMethod, PsiSubstitutor.EMPTY, results)) continue;
                results.add((Pair<PsiMethod, PsiSubstitutor>)Pair.pair((Object)psiMethod, (Object)PsiSubstitutor.EMPTY));
            }
        } while (null != (psiClass2 = (psiClass = psiClass2.getSuperClass()) instanceof PsiExtensibleClass ? (psiExtensibleSuperClass = (PsiExtensibleClass)psiClass) : null));
    }

    private static boolean isAcceptableMethod(PsiMethod psiMethod) {
        return !psiMethod.isConstructor() && psiMethod.hasModifierProperty("public") && !psiMethod.hasModifierProperty("static");
    }

    private static Collection<Pair<PsiMethod, PsiSubstitutor>> findMethodsToDelegate(Collection<Pair<PsiMethod, PsiSubstitutor>> includesMethods, Collection<Pair<PsiMethod, PsiSubstitutor>> excludeMethods) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (Pair<PsiMethod, PsiSubstitutor> includesMethodPair : includesMethods) {
            if (DelegateHandler.isAlreadyPresent((PsiMethod)includesMethodPair.getFirst(), (PsiSubstitutor)includesMethodPair.getSecond(), excludeMethods)) continue;
            result.add(includesMethodPair);
        }
        return result;
    }

    private static boolean isAlreadyPresent(PsiMethod psiMethod, PsiSubstitutor psiSubstitutor, Collection<Pair<PsiMethod, PsiSubstitutor>> searchedPairs) {
        boolean acceptMethod = true;
        for (Pair<PsiMethod, PsiSubstitutor> someMethodPair : searchedPairs) {
            if (!DelegateHandler.methodMatches(psiMethod, psiSubstitutor, (PsiMethod)someMethodPair.getFirst(), (PsiSubstitutor)someMethodPair.getSecond())) continue;
            acceptMethod = false;
            break;
        }
        return !acceptMethod;
    }

    @NotNull
    private static <T extends PsiModifierListOwner & PsiNamedElement> PsiMethod generateDelegateMethod(@NotNull PsiClass psiClass, @NotNull T psiElement, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiMethod psiMethod, @NotNull PsiSubstitutor psiSubstitutor) {
        PsiParameter[] psiParameters;
        if (psiClass == null) {
            DelegateHandler.$$$reportNull$$$0(13);
        }
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(15);
        }
        if (psiMethod == null) {
            DelegateHandler.$$$reportNull$$$0(16);
        }
        if (psiSubstitutor == null) {
            DelegateHandler.$$$reportNull$$$0(17);
        }
        PsiType returnType = psiSubstitutor.substitute(psiMethod.getReturnType());
        LombokLightMethodBuilder methodBuilder = new LombokDelegateMethod(psiMethod).withModifier("public").withMethodReturnType(returnType).withContainingClass(psiClass).withNavigationElement((PsiElement)psiMethod);
        for (PsiTypeParameter typeParameter : psiMethod.getTypeParameters()) {
            LightTypeParameterBuilder lightTypeParameter = new LightTypeParameterBuilder(typeParameter.getName(), (PsiTypeParameterListOwner)psiMethod, typeParameter.getIndex());
            for (PsiClassType extendsListType : typeParameter.getExtendsListTypes()) {
                lightTypeParameter.getExtendsList().addReference((PsiClassType)psiSubstitutor.substitute((PsiType)extendsListType));
            }
            for (PsiClassType implementsListType : typeParameter.getImplementsListTypes()) {
                lightTypeParameter.getImplementsList().addReference((PsiClassType)psiSubstitutor.substitute((PsiType)implementsListType));
            }
            methodBuilder.withTypeParameter((PsiTypeParameter)lightTypeParameter);
        }
        PsiReferenceList throwsList = psiMethod.getThrowsList();
        for (PsiClassType psiClassType : throwsList.getReferencedTypes()) {
            methodBuilder.withException(psiClassType);
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        for (PsiParameter psiParameter : psiParameters = parameterList.getParameters()) {
            PsiType psiParameterType = psiSubstitutor.substitute(psiParameter.getType());
            methodBuilder.withParameter(psiParameter.getName(), psiParameterType);
        }
        String codeBlockText = DelegateHandler.createCodeBlockText(psiElement, psiMethod, returnType, psiParameters);
        methodBuilder.withBodyText(codeBlockText);
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            DelegateHandler.$$$reportNull$$$0(18);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private static <T extends PsiModifierListOwner & PsiNamedElement> String createCodeBlockText(@NotNull T psiElement, @NotNull PsiMethod psiMethod, @NotNull PsiType returnType, PsiParameter @NotNull [] psiParameters) {
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(19);
        }
        if (psiMethod == null) {
            DelegateHandler.$$$reportNull$$$0(20);
        }
        if (returnType == null) {
            DelegateHandler.$$$reportNull$$$0(21);
        }
        if (psiParameters == null) {
            DelegateHandler.$$$reportNull$$$0(22);
        }
        String paramString = Arrays.stream(psiParameters).map(PsiParameter::getName).collect(Collectors.joining(","));
        boolean isMethodCall = psiElement instanceof PsiMethod;
        String string = String.format("%sthis.%s%s.%s(%s);", PsiTypes.voidType().equals((Object)returnType) ? "" : "return ", ((PsiNamedElement)psiElement).getName(), isMethodCall ? "()" : "", psiMethod.getName(), paramString);
        if (string == null) {
            DelegateHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static boolean methodMatches(@NotNull PsiMethod firstMethod, @NotNull PsiSubstitutor firstSubstitutor, @NotNull PsiMethod secondMethod, @NotNull PsiSubstitutor secondSubstitutor) {
        if (firstMethod == null) {
            DelegateHandler.$$$reportNull$$$0(24);
        }
        if (firstSubstitutor == null) {
            DelegateHandler.$$$reportNull$$$0(25);
        }
        if (secondMethod == null) {
            DelegateHandler.$$$reportNull$$$0(26);
        }
        if (secondSubstitutor == null) {
            DelegateHandler.$$$reportNull$$$0(27);
        }
        if (!firstMethod.getName().equals(secondMethod.getName())) {
            return false;
        }
        PsiParameterList firstMethodParameterList = firstMethod.getParameterList();
        PsiParameterList secondMethodParameterList = secondMethod.getParameterList();
        if (firstMethodParameterList.getParametersCount() != secondMethodParameterList.getParametersCount()) {
            return false;
        }
        PsiParameter[] firstMethodParameters = firstMethodParameterList.getParameters();
        PsiParameter[] secondMethodParameters = secondMethodParameterList.getParameters();
        for (int i = 0; i < firstMethodParameters.length; ++i) {
            PsiType secondParameterType;
            PsiType firstMethodParameterListParameterType = firstSubstitutor.substitute(firstMethodParameters[i].getType());
            PsiType secondMethodParameterListParameterType = secondSubstitutor.substitute(secondMethodParameters[i].getType());
            PsiType firstParameterType = TypeConversionUtil.erasure((PsiType)firstMethodParameterListParameterType, (PsiSubstitutor)firstSubstitutor);
            if (PsiElementUtil.typesAreEquivalent(firstParameterType, secondParameterType = TypeConversionUtil.erasure((PsiType)secondMethodParameterListParameterType, (PsiSubstitutor)secondSubstitutor))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTargetType";
                break;
            }
            case 2: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = TYPES_PARAMETER;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 8: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiStartClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSubstitutor";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/DelegateHandler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameters";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstMethod";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstSubstitutor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondMethod";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/DelegateHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDelegateMethod";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateTypesMethodsExistsInDelegateTargetType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkConcreteClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectAllOwnMethods";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateMethod";
                break;
            }
            case 18: 
            case 23: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockText";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 23 -> new IllegalStateException(string);
        };
    }

    private static class DelegateAnnotationElementVisitor
    extends JavaElementVisitor {
        private final PsiType psiType;
        private final ProblemSink builder;
        private boolean valid;

        DelegateAnnotationElementVisitor(PsiType psiType, ProblemSink builder) {
            this.psiType = psiType;
            this.builder = builder;
            this.valid = true;
        }

        public void visitField(@NotNull PsiField psiField) {
            if (psiField == null) {
                DelegateAnnotationElementVisitor.$$$reportNull$$$0(0);
            }
            this.checkModifierListOwner((PsiModifierListOwner)psiField);
        }

        public void visitMethod(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                DelegateAnnotationElementVisitor.$$$reportNull$$$0(1);
            }
            this.checkModifierListOwner((PsiModifierListOwner)psiMethod);
        }

        private void checkModifierListOwner(PsiModifierListOwner modifierListOwner) {
            if (PsiAnnotationSearchUtil.isAnnotatedWith(modifierListOwner, "lombok.Delegate", "lombok.experimental.Delegate")) {
                this.builder.addErrorMessage("inspection.message.delegate.does.not.support.recursion.delegating", ((PsiMember)modifierListOwner).getName(), this.psiType.getPresentableText());
                this.valid = false;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
            }
            objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/DelegateHandler$DelegateAnnotationElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

