/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.ui;

import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.liquibase.common.config.LiquibaseChange;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.ChangeLogTree;
import com.intellij.liquibase.common.gui.ChangeLogTreeBuilder;
import com.intellij.liquibase.common.gui.ChangeLogTreeKt;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.liquibase.common.gui.PreviewDialogSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/flyway/ui/FlywayDiffTree;", "Lcom/intellij/liquibase/common/gui/ChangeLogTree;", "project", "Lcom/intellij/openapi/project/Project;", "changeLogs", "", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "Lcom/intellij/psi/xml/XmlTag;", "previewDialogSettings", "Lcom/intellij/liquibase/common/gui/PreviewDialogSettings;", "actionGroup", "", "builder", "Lcom/intellij/liquibase/common/gui/ChangeLogTreeBuilder;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/intellij/liquibase/common/gui/PreviewDialogSettings;Ljava/lang/String;Lcom/intellij/liquibase/common/gui/ChangeLogTreeBuilder;Lcom/intellij/openapi/Disposable;)V", "selectChangesByDangerLevel", "", "dangerLevel", "Lcom/intellij/liquibase/common/config/LiquibaseChange$DangerLevel;", "isDragInto", "", "draggedUserObject", "", "targetUserObject", "intellij.flyway"})
public final class FlywayDiffTree
extends ChangeLogTree {
    public FlywayDiffTree(@NotNull Project project, @NotNull Map<DataStore, ? extends XmlTag> changeLogs, @NotNull PreviewDialogSettings previewDialogSettings, @NotNull String actionGroup, @NotNull ChangeLogTreeBuilder builder, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changeLogs, (String)"changeLogs");
        Intrinsics.checkNotNullParameter((Object)previewDialogSettings, (String)"previewDialogSettings");
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, changeLogs, previewDialogSettings, actionGroup, builder, parentDisposable);
    }

    public void selectChangesByDangerLevel(@NotNull LiquibaseChange.DangerLevel dangerLevel) {
        Intrinsics.checkNotNullParameter((Object)dangerLevel, (String)"dangerLevel");
        Collection changeNodes = ChangeLogTreeKt.getChildrenNodeByUserObjectType((DefaultMutableTreeNode)this.getRootNode(), ChangeModel.class, (boolean)true);
        for (DefaultMutableTreeNode changeNode : changeNodes) {
            Object object = changeNode.getUserObject();
            ChangeModel changeModel = object instanceof ChangeModel ? (ChangeModel)object : null;
            if ((changeModel != null ? changeModel.getDangerLevel() : null) != dangerLevel) continue;
            this.addSelectionPath(new TreePath(changeNode.getPath()));
        }
    }

    protected boolean isDragInto(@Nullable Object draggedUserObject, @Nullable Object targetUserObject) {
        return super.isDragInto(draggedUserObject, targetUserObject) || draggedUserObject instanceof ChangeModel && targetUserObject instanceof ChangeLogModel;
    }
}

