/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.references;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.HelmResolver;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.references.ReferenceContributorsKt;
import com.intellij.kubernetes.helm.references.RegularHelmValueReference;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/helm/references/ChartsYamlReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "intellij.clouds.kubernetes.backend"})
public final class ChartsYamlReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(YAMLScalar.class).and((ElementPattern)ReferenceContributorsKt.access$getChartYamlFilePattern$p()), new PsiReferenceProvider(){

            public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!(element instanceof YAMLScalar)) {
                    return new PsiReference[0];
                }
                PsiElement psiElement = ((YAMLScalar)element).getParent();
                YAMLKeyValue yAMLKeyValue = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
                if (yAMLKeyValue == null) {
                    return new PsiReference[0];
                }
                YAMLKeyValue keyVal = yAMLKeyValue;
                YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((PsiElement)((PsiElement)keyVal));
                if (!Intrinsics.areEqual((Object)keyVal, (Object)(yAMLMapping != null ? YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"name") : null))) {
                    return new PsiReference[0];
                }
                VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)keyVal));
                if (virtualFile == null) {
                    return new PsiReference[0];
                }
                VirtualFile chartFile = virtualFile;
                Project project = ((YAMLScalar)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<ChartManager> serviceClass$iv = ChartManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Chart chart = ((ChartManager)object).findChartByRelatedFile(chartFile);
                if (chart == null) {
                    return new PsiReference[0];
                }
                Chart chart2 = chart;
                Project project2 = ((YAMLScalar)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                PathInChart pathInChart = HelmResolver.Companion.getInstance(project2).getRootPathInChart(chart2);
                PsiReference[] psiReferenceArray = new PsiReference[]{new RegularHelmValueReference(element, pathInChart)};
                return psiReferenceArray;
            }
        });
    }
}

