/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabasePasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.ui.AuthWidgetBuilderBase;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.util.DbUiUtilCore;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AuthWidgetBuilderImpl
extends AuthWidgetBuilderBase {
    private final List<FieldFactory> myDescriptors = new ArrayList<FieldFactory>();

    @Nullable
    public DatabaseAuthProvider.AuthWidget build(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        if (credentials == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(0);
        }
        if (config == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(1);
        }
        if (this.myDescriptors.isEmpty()) {
            return null;
        }
        return new Widget(ContainerUtil.map(this.myDescriptors, f -> f.create(project, credentials, (DatabaseConnectionPoint)config)));
    }

    @Override
    public AuthWidgetBuilderImpl addTextField(@NotNull Supplier<@NlsContexts.Label String> label, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        if (label == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(2);
        }
        if (serialiser == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(3);
        }
        return this.addFactory((project, credentials, config) -> new TextField((String)label.get(), serialiser, urlHandler));
    }

    @Override
    public AuthWidgetBuilder addTextField(@NotNull Supplier<@NlsContexts.Label String> label, @NotNull AuthWidgetBuilder.CompletionProvider completion, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        if (label == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(4);
        }
        if (completion == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(5);
        }
        if (serialiser == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(6);
        }
        return this.addFactory((project, credentials, config) -> new TextFieldWithCompletion(project, (String)label.get(), completion, serialiser, urlHandler));
    }

    @Override
    public AuthWidgetBuilderImpl addFileField(@NotNull Supplier<@NlsContexts.Label String> label, @NotNull Supplier<@NlsContexts.Label String> description, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        if (label == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(7);
        }
        if (description == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(8);
        }
        if (serialiser == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(9);
        }
        return this.addFactory((project, credentials, config) -> new FileField(project, (String)label.get(), (String)description.get(), serialiser, urlHandler));
    }

    @Override
    public AuthWidgetBuilderImpl addPasswordField(@NotNull Supplier<@NlsContexts.Label String> label, @NotNull AuthWidgetBuilder.Serialiser<OneTimeString> serialiser, boolean withStorage, @Nullable AuthWidgetBuilder.UrlHandler<OneTimeString> urlHandler) {
        if (label == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(10);
        }
        if (serialiser == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(11);
        }
        return this.addFactory((project, credentials, config) -> new PasswordField((String)label.get(), credentials, serialiser, config, withStorage, urlHandler));
    }

    @Override
    public AuthWidgetBuilder addCheckBox(@NotNull Supplier<@NlsContexts.Label String> label, @NotNull AuthWidgetBuilder.Serialiser<Boolean> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<Boolean> urlHandler) {
        if (label == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(12);
        }
        if (serialiser == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(13);
        }
        return this.addFactory((project, credentials, config) -> new CheckBoxField((String)label.get(), serialiser, urlHandler));
    }

    @Override
    public AuthWidgetBuilder addHandler(String value, @Nullable AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        return this.addFactory((project, credentials, config) -> new FakeField(value, serialiser, urlHandler));
    }

    @NotNull
    private AuthWidgetBuilderImpl addFactory(FieldFactory factory) {
        this.myDescriptors.add(factory);
        AuthWidgetBuilderImpl authWidgetBuilderImpl = this;
        if (authWidgetBuilderImpl == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(14);
        }
        return authWidgetBuilderImpl;
    }

    @TestOnly
    public static void setPasswordStorage(@Nullable DatabaseAuthProvider.AuthWidget widget, @NotNull LocalDataSource.Storage storage) {
        PasswordField passwordField;
        if (storage == null) {
            AuthWidgetBuilderImpl.$$$reportNull$$$0(15);
        }
        if ((passwordField = AuthWidgetBuilderImpl.getPasswordField(widget)) != null && passwordField.myPasswordStorage != null) {
            passwordField.myPasswordStorage.setPasswordStorage(storage);
        }
    }

    @TestOnly
    public static void setPassword(@Nullable DatabaseAuthProvider.AuthWidget widget, @Nullable String password) {
        PasswordField passwordField = AuthWidgetBuilderImpl.getPasswordField(widget);
        if (passwordField != null) {
            passwordField.myPasswordField.setPassword(password);
        }
    }

    @TestOnly
    @Nullable
    public static String getVisiblePassword(@Nullable DatabaseAuthProvider.AuthWidget widget) {
        PasswordField passwordField = AuthWidgetBuilderImpl.getPasswordField(widget);
        char[] p = passwordField == null ? null : passwordField.myPasswordField.getPasswordOpt();
        return p == null ? null : new String(p);
    }

    @TestOnly
    private static PasswordField getPasswordField(@Nullable DatabaseAuthProvider.AuthWidget widget) {
        return (PasswordField)ContainerUtil.findInstance(AuthWidgetBuilderImpl.getFields(widget), PasswordField.class);
    }

    @TestOnly
    private static List<Field> getFields(@Nullable DatabaseAuthProvider.AuthWidget widget) {
        Widget w = (Widget)ObjectUtils.tryCast((Object)widget, Widget.class);
        return w == null ? Collections.emptyList() : w.myFields;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialiser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTextField";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFileField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPasswordField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCheckBox";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setPasswordStorage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }

    private static class Widget
    implements DatabaseAuthProvider.AuthWidget {
        private final List<Field> myFields;
        private final JComponent myPanel;
        private final JComponent myToFocus;

        private Widget(@NotNull List<Field> descriptors) {
            if (descriptors == null) {
                Widget.$$$reportNull$$$0(0);
            }
            this.myFields = descriptors;
            this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(this.myFields.size(), 6));
            JComponent toFocus = null;
            int row = 0;
            for (Field descriptor2 : this.myFields) {
                JComponent cur = descriptor2.add(row++, this.myPanel);
                if (toFocus != null) continue;
                toFocus = cur;
            }
            this.myToFocus = toFocus == null ? this.myPanel : toFocus;
        }

        public void onChanged(@NotNull Runnable r) {
            if (r == null) {
                Widget.$$$reportNull$$$0(1);
            }
            for (Field descriptor2 : this.myFields) {
                descriptor2.onChanged(r);
            }
        }

        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                Widget.$$$reportNull$$$0(2);
            }
            for (Field descriptor2 : this.myFields) {
                descriptor2.save(config, copyCredentials);
            }
        }

        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                Widget.$$$reportNull$$$0(3);
            }
            for (Field descriptor2 : this.myFields) {
                descriptor2.reset(point, resetCredentials);
            }
        }

        public boolean isPasswordChanged() {
            return ContainerUtil.find(this.myFields, DatabaseAuthProvider.AuthWidget::isPasswordChanged) != null;
        }

        public void hidePassword() {
            for (Field descriptor2 : this.myFields) {
                descriptor2.hidePassword();
            }
        }

        public void reloadCredentials() {
            for (Field descriptor2 : this.myFields) {
                descriptor2.reloadCredentials();
            }
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                Widget.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JComponent jComponent = this.myToFocus;
            if (jComponent == null) {
                Widget.$$$reportNull$$$0(5);
            }
            return jComponent;
        }

        public void forceSave() {
            for (Field descriptor2 : this.myFields) {
                descriptor2.forceSave();
            }
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            if (holder == null) {
                Widget.$$$reportNull$$$0(6);
            }
            for (Field descriptor2 : this.myFields) {
                descriptor2.updateFromUrl(holder);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                Widget.$$$reportNull$$$0(7);
            }
            for (Field descriptor2 : this.myFields) {
                descriptor2.updateUrl(model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$Widget";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$Widget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromUrl";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateUrl";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static interface FieldFactory {
        @NotNull
        public Field create(@Nullable Project var1, @NotNull DatabaseCredentials var2, @NotNull DatabaseConnectionPoint var3);
    }

    private static class PasswordField
    extends Field {
        private final @NlsContexts.Label String myLabel;
        private final AuthWidgetBuilder.UrlHandler<OneTimeString> myUrlHandler;
        private final DatabasePasswordField myPasswordField;
        @Nullable
        private final PasswordStorageComponent myPasswordStorage;

        private PasswordField(@NlsContexts.Label String label, @NotNull DatabaseCredentials credentials, final @NotNull AuthWidgetBuilder.Serialiser<OneTimeString> serialiser, final @NotNull DatabaseConnectionPoint config, boolean withStorage, @Nullable AuthWidgetBuilder.UrlHandler<OneTimeString> urlHandler) {
            if (credentials == null) {
                PasswordField.$$$reportNull$$$0(0);
            }
            if (serialiser == null) {
                PasswordField.$$$reportNull$$$0(1);
            }
            if (config == null) {
                PasswordField.$$$reportNull$$$0(2);
            }
            this.myLabel = label;
            this.myUrlHandler = urlHandler;
            this.myPasswordField = new DatabasePasswordField(credentials, config){

                @Override
                @Nullable
                protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionPoint point) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (point == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return (OneTimeString)serialiser.load(point, credentials);
                }

                @Override
                protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig point, @Nullable OneTimeString password) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (point == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    serialiser.save((Object)password, point, credentials);
                }

                @Override
                protected DatabaseConnectionConfig getActualTarget() {
                    LocalDataSource tempDataSource = config.getDataSource().copy(true);
                    Object copy = config instanceof LocalDataSource ? tempDataSource : ((DataSourceSessionTemplate)config).copyTo(tempDataSource);
                    if (myPasswordStorage != null) {
                        LocalDataSource.setPasswordStorage((DatabaseConnectionConfig)copy, (LocalDataSource.Storage)myPasswordStorage.getStorage());
                    }
                    return copy;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "credentials";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "point";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$PasswordField$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extractPassword";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setPassword";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myPasswordStorage = withStorage ? new PasswordStorageComponent() : null;
        }

        @Override
        @Nullable
        public JComponent add(int row, JComponent panel2) {
            JBLabel passwordLabel = new JBLabel(this.myLabel);
            passwordLabel.setLabelFor((Component)this.myPasswordField.getComponent());
            panel2.add((Component)passwordLabel, DatabaseUIUtils.createLabelConstraints(row, 0, passwordLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myPasswordField.getComponent(), DatabaseUIUtils.createSimpleConstraints(row, 1, 3));
            if (this.myPasswordStorage != null) {
                JBLabel rememberLabel = new JBLabel(DatabaseBundle.message((String)"database.auth.password.storage.label", (Object[])new Object[0]));
                rememberLabel.setBorder(DatabaseUIUtils.innerLabelBorder());
                rememberLabel.setLabelFor(this.myPasswordStorage.getComponent());
                panel2.add((Component)rememberLabel, DatabaseUIUtils.createLabelConstraints(row, 4, rememberLabel.getPreferredSize().getWidth()));
                panel2.add(this.myPasswordStorage.getComponent(), DatabaseUIUtils.createConstraints(row, 5, 1, 0, 1, -2, true));
            }
            return this.myPasswordField.getComponent();
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                PasswordField.$$$reportNull$$$0(3);
            }
            this.myPasswordField.getComponent().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(this){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$PasswordField$2", "textChanged"));
                }
            });
            if (this.myPasswordStorage != null) {
                this.myPasswordStorage.getComponent().addItemListener(event -> r.run());
            }
        }

        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                PasswordField.$$$reportNull$$$0(4);
            }
            if (this.myPasswordStorage != null) {
                LocalDataSource.setPasswordStorage((DatabaseConnectionConfig)config, (LocalDataSource.Storage)this.myPasswordStorage.getStorage());
            }
            if (copyCredentials) {
                this.myPasswordField.save(config);
            }
        }

        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                PasswordField.$$$reportNull$$$0(5);
            }
            if (this.myPasswordStorage != null) {
                this.myPasswordStorage.setPasswordStorage(LocalDataSource.getPasswordStorage((DatabaseConnectionPoint)point));
            }
            if (resetCredentials) {
                this.myPasswordField.setPassword(null);
            }
        }

        public boolean isPasswordChanged() {
            return this.myPasswordField.isModified();
        }

        public void hidePassword() {
            this.myPasswordField.moveToStorage();
        }

        public void reloadCredentials() {
            this.myPasswordField.changedInStorage();
        }

        public void forceSave() {
            if (this.myPasswordField.getPassword() == null) {
                this.myPasswordField.setPassword("");
            }
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            OneTimeString fromParser;
            String passwordFromParser;
            if (holder == null) {
                PasswordField.$$$reportNull$$$0(6);
            }
            String string = passwordFromParser = (fromParser = (OneTimeString)this.myUrlHandler.fromUrl(holder)) == null ? null : fromParser.toString();
            if (StringUtil.isNotEmpty((String)passwordFromParser)) {
                this.myPasswordField.setPassword(passwordFromParser);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                PasswordField.$$$reportNull$$$0(7);
            }
            this.myUrlHandler.toUrl(null, model);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$PasswordField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFromUrl";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FakeField
    extends Field {
        private final String myValue;
        @Nullable
        private final AuthWidgetBuilder.Serialiser<String> mySerialiser;
        @Nullable
        private final AuthWidgetBuilder.UrlHandler<String> myUrlHandler;

        private FakeField(String value, @Nullable AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            this.myValue = value;
            this.mySerialiser = serialiser;
            this.myUrlHandler = urlHandler;
        }

        public void onChanged(@NotNull Runnable r) {
            if (r == null) {
                FakeField.$$$reportNull$$$0(0);
            }
        }

        @Override
        @Nullable
        public JComponent add(int row, JComponent panel2) {
            return null;
        }

        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                FakeField.$$$reportNull$$$0(1);
            }
            if (this.mySerialiser != null) {
                this.mySerialiser.save((Object)this.myValue, config, null);
            }
        }

        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                FakeField.$$$reportNull$$$0(2);
            }
            if (this.mySerialiser != null) {
                this.mySerialiser.load(point, null);
            }
        }

        public boolean isPasswordChanged() {
            return false;
        }

        public void hidePassword() {
        }

        public void reloadCredentials() {
        }

        public void forceSave() {
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            if (holder == null) {
                FakeField.$$$reportNull$$$0(3);
            }
            if (this.myUrlHandler != null) {
                this.myUrlHandler.fromUrl(holder);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                FakeField.$$$reportNull$$$0(4);
            }
            if (this.myUrlHandler != null) {
                this.myUrlHandler.toUrl((Object)this.myValue, model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$FakeField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFromUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CheckBoxField
    extends Field {
        private final JBCheckBox myComponent;
        private final AuthWidgetBuilder.Serialiser<Boolean> mySerialiser;
        private final AuthWidgetBuilder.UrlHandler<Boolean> myUrlHandler;

        private CheckBoxField(@NlsContexts.Label String label, @NotNull AuthWidgetBuilder.Serialiser<Boolean> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<Boolean> urlHandler) {
            if (serialiser == null) {
                CheckBoxField.$$$reportNull$$$0(0);
            }
            this.myComponent = new JBCheckBox(label);
            this.mySerialiser = serialiser;
            this.myUrlHandler = urlHandler;
        }

        public void onChanged(@NotNull Runnable r) {
            if (r == null) {
                CheckBoxField.$$$reportNull$$$0(1);
            }
            this.myComponent.addItemListener(event -> r.run());
        }

        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                CheckBoxField.$$$reportNull$$$0(2);
            }
            this.mySerialiser.save((Object)this.myComponent.isSelected(), config, null);
        }

        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                CheckBoxField.$$$reportNull$$$0(3);
            }
            this.myComponent.setSelected(Boolean.TRUE.equals(this.mySerialiser.load(point, null)));
        }

        public boolean isPasswordChanged() {
            return false;
        }

        public void hidePassword() {
        }

        public void reloadCredentials() {
        }

        public void forceSave() {
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            Boolean param;
            if (holder == null) {
                CheckBoxField.$$$reportNull$$$0(4);
            }
            if (this.myUrlHandler != null && (param = (Boolean)this.myUrlHandler.fromUrl(holder)) != null) {
                this.myComponent.setSelected(param.booleanValue());
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                CheckBoxField.$$$reportNull$$$0(5);
            }
            if (this.myUrlHandler != null) {
                this.myUrlHandler.toUrl((Object)this.myComponent.isSelected(), model);
            }
        }

        @Override
        @Nullable
        public JComponent add(int row, JComponent panel2) {
            panel2.add((Component)this.myComponent, DatabaseUIUtils.createRowConstraints(row));
            return this.myComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$CheckBoxField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFromUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileField
    extends TextFieldBase<TextFieldWithBrowseButton> {
        private FileField(@Nullable Project project, @NlsContexts.Label String label, @NlsContexts.Label String description, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            if (serialiser == null) {
                FileField.$$$reportNull$$$0(0);
            }
            super(label, new TextFieldWithBrowseButton(), serialiser, urlHandler);
            ((TextFieldWithBrowseButton)this.myComponent).addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(label).withDescription(description));
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                FileField.$$$reportNull$$$0(1);
            }
            ((TextFieldWithBrowseButton)this.myComponent).getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(this){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$FileField$1", "textChanged"));
                }
            });
        }

        @NotNull
        public String getText() {
            String string = ((TextFieldWithBrowseButton)this.myComponent).getText();
            if (string == null) {
                FileField.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                FileField.$$$reportNull$$$0(3);
            }
            ((TextFieldWithBrowseButton)this.myComponent).setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$FileField";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$FileField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class TextFieldWithCompletion
    extends TextFieldBase<TextFieldWithAutoCompletion<String>> {
        @NotNull
        private final MyCompletionProvider myProvider;

        private TextFieldWithCompletion(@Nullable Project project, @NlsContexts.Label String label, @NotNull AuthWidgetBuilder.CompletionProvider provider, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            if (provider == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(0);
            }
            if (serialiser == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(1);
            }
            this(project, label, new MyCompletionProvider(provider), serialiser, urlHandler);
        }

        private TextFieldWithCompletion(@Nullable Project project, @NlsContexts.Label String label, @NotNull MyCompletionProvider provider, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            if (provider == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(2);
            }
            if (serialiser == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(3);
            }
            super(label, new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)provider, true, null), serialiser, urlHandler);
            this.myProvider = provider;
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(4);
            }
            ((TextFieldWithAutoCompletion)this.myComponent).getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldWithCompletion$1", "documentChanged"));
                }
            });
        }

        @NotNull
        public String getText() {
            String string = ((TextFieldWithAutoCompletion)this.myComponent).getText();
            if (string == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(6);
            }
            ((TextFieldWithAutoCompletion)this.myComponent).setText(text);
        }

        @Override
        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(7);
            }
            super.reset(point, resetCredentials);
            this.updateCompletion(point);
        }

        private void updateCompletion(@NotNull DatabaseConnectionPoint point) {
            if (point == null) {
                TextFieldWithCompletion.$$$reportNull$$$0(8);
            }
            this.myProvider.updateCompletion(point);
            DbUiUtilCore.setError((JComponent)this.myComponent, (String)this.myProvider.error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldWithCompletion";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldWithCompletion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCompletion";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }

        private static class MyCompletionProvider
        extends TextFieldWithAutoCompletionListProvider<String> {
            @NotNull
            private final AuthWidgetBuilder.CompletionProvider myProvider;
            private @NlsContexts.Tooltip String error;

            MyCompletionProvider(@NotNull AuthWidgetBuilder.CompletionProvider provider) {
                if (provider == null) {
                    MyCompletionProvider.$$$reportNull$$$0(0);
                }
                super(Collections.emptyList());
                this.error = null;
                this.myProvider = provider;
            }

            private void updateCompletion(DatabaseConnectionPoint point) {
                this.error = null;
                try {
                    List items = this.myProvider.getItems(point, e -> {
                        this.error = e;
                    });
                    this.setItems(items);
                }
                catch (Throwable th) {
                    this.error = th.getMessage();
                }
            }

            @NotNull
            protected String getLookupString(@NotNull String item) {
                if (item == null) {
                    MyCompletionProvider.$$$reportNull$$$0(1);
                }
                String string = item;
                if (string == null) {
                    MyCompletionProvider.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldWithCompletion$MyCompletionProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldWithCompletion$MyCompletionProvider";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class TextField
    extends TextFieldBase<JBTextField> {
        private TextField(@NlsContexts.Label String label, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            if (serialiser == null) {
                TextField.$$$reportNull$$$0(0);
            }
            super(label, new JBTextField(), serialiser, urlHandler);
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                TextField.$$$reportNull$$$0(1);
            }
            ((JBTextField)this.myComponent).getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(this){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextField$1", "textChanged"));
                }
            });
        }

        @NotNull
        public String getText() {
            String string = ((JBTextField)this.myComponent).getText();
            if (string == null) {
                TextField.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                TextField.$$$reportNull$$$0(3);
            }
            ((JBTextField)this.myComponent).setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextField";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class Field
    implements DatabaseAuthProvider.AuthWidget {
        private Field() {
        }

        @Nullable
        public abstract JComponent add(int var1, JComponent var2);

        @Nullable
        protected JComponent addLabeled(int row, JComponent panel2, @NlsContexts.Label @NotNull String label, @NotNull JComponent component) {
            if (label == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (component == null) {
                Field.$$$reportNull$$$0(1);
            }
            JBLabel lbl = new JBLabel(label);
            lbl.setLabelFor((Component)component);
            panel2.add((Component)lbl, DatabaseUIUtils.createLabelConstraints(row, 0, lbl.getPreferredSize().getWidth()));
            panel2.add((Component)component, DatabaseUIUtils.createSimpleConstraints(row, 1, 3));
            return component;
        }

        @NotNull
        public JComponent getComponent() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "label";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$Field";
            objectArray[2] = "addLabeled";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TextFieldBase<C extends JComponent>
    extends Field
    implements TextAccessor {
        private final @NlsContexts.Label String myLabel;
        @NotNull
        private final AuthWidgetBuilder.Serialiser<String> mySerialiser;
        @Nullable
        private final AuthWidgetBuilder.UrlHandler<String> myUrlHandler;
        protected final C myComponent;

        private TextFieldBase(@NlsContexts.Label String label, C component, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
            if (serialiser == null) {
                TextFieldBase.$$$reportNull$$$0(0);
            }
            this.myLabel = label;
            this.mySerialiser = serialiser;
            this.myUrlHandler = urlHandler;
            this.myComponent = component;
        }

        @Override
        @Nullable
        public JComponent add(int row, JComponent panel2) {
            return this.addLabeled(row, panel2, this.myLabel, (JComponent)this.myComponent);
        }

        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                TextFieldBase.$$$reportNull$$$0(1);
            }
            this.mySerialiser.save((Object)StringUtil.nullize((String)this.getText()), config, null);
        }

        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                TextFieldBase.$$$reportNull$$$0(2);
            }
            this.setText(StringUtil.notNullize((String)((String)this.mySerialiser.load(point, null))));
        }

        public boolean isPasswordChanged() {
            return false;
        }

        public void hidePassword() {
        }

        public void reloadCredentials() {
        }

        public void forceSave() {
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            String param;
            if (holder == null) {
                TextFieldBase.$$$reportNull$$$0(3);
            }
            if (this.myUrlHandler != null && StringUtil.isNotEmpty((String)(param = (String)this.myUrlHandler.fromUrl(holder)))) {
                this.setText(param);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                TextFieldBase.$$$reportNull$$$0(4);
            }
            if (this.myUrlHandler != null) {
                this.myUrlHandler.toUrl((Object)this.getText(), model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialiser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilderImpl$TextFieldBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFromUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

