/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.ide.util.PropertiesComponent;
import org.jetbrains.annotations.NotNull;

public final class FullTextSearchOptionsStorage {
    private static final String MAX_NUM_OF_FETCHED_ROWS_KEY = "fts_max_num_of_fetched_rows";
    private static final String LOCATION_KEY = "fts_location";
    private static final String SEARCH_SCOPE_KEY = "fts_scope_target";
    private static final String MATCH_CASE_KEY = "fts_match_case";
    private static final String TEXT_KEY = "fts_text";

    public static void store(@NotNull FullTextSearchOptions options) {
        if (options == null) {
            FullTextSearchOptionsStorage.$$$reportNull$$$0(0);
        }
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(MAX_NUM_OF_FETCHED_ROWS_KEY, options.getMaxNumOfFetchedRows(), 10);
        props.setValue(LOCATION_KEY, options.getLocation().name(), FullTextSearchOptions.DEFAULT_LOCATION.name());
        props.setValue(SEARCH_SCOPE_KEY, options.getSearchScope().name(), FullTextSearchOptions.DEFAULT_SEARCH_SCOPE.name());
        props.setValue(MATCH_CASE_KEY, options.isMatchCase(), false);
        props.setValue(TEXT_KEY, options.getText(), "");
    }

    public static String getText() {
        return PropertiesComponent.getInstance().getValue(TEXT_KEY, "");
    }

    public static int getMaxNumOfFetchedRows() {
        return PropertiesComponent.getInstance().getInt(MAX_NUM_OF_FETCHED_ROWS_KEY, 10);
    }

    public static FullTextSearchOptions.Location getLocation() {
        String locationName = PropertiesComponent.getInstance().getValue(LOCATION_KEY);
        if (locationName == null) {
            return FullTextSearchOptions.DEFAULT_LOCATION;
        }
        try {
            return FullTextSearchOptions.Location.valueOf(locationName);
        }
        catch (IllegalArgumentException ignored) {
            return FullTextSearchOptions.DEFAULT_LOCATION;
        }
    }

    public static FullTextSearchOptions.SearchScope getSearchTarget() {
        String searchTargetName = PropertiesComponent.getInstance().getValue(SEARCH_SCOPE_KEY);
        if (searchTargetName == null) {
            return FullTextSearchOptions.DEFAULT_SEARCH_SCOPE;
        }
        try {
            return FullTextSearchOptions.SearchScope.valueOf(searchTargetName);
        }
        catch (IllegalArgumentException ignored) {
            return FullTextSearchOptions.DEFAULT_SEARCH_SCOPE;
        }
    }

    public static boolean getMatchCase() {
        return PropertiesComponent.getInstance().getBoolean(MATCH_CASE_KEY, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/fulltextsearch/FullTextSearchOptionsStorage", "store"));
    }
}

