/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.tree.AbstractTree;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvMoveArmsToFolder;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.awt.RelativeRectangle;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0015\u0010\u001b\u001a\u0004\u0018\u00010\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0082\u0010J\u0013\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0000H\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/view/DvFolderDropTarget;", "Lcom/intellij/ide/dnd/DnDTarget;", "project", "Lcom/intellij/openapi/project/Project;", "folder", "Lcom/intellij/database/view/structure/forest/DvFolder;", "jTree", "Ljavax/swing/JTree;", "abstractTree", "Lcom/intellij/database/util/tree/AbstractTree;", "Lcom/intellij/database/model/basic/BasicNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/forest/DvFolder;Ljavax/swing/JTree;Lcom/intellij/database/util/tree/AbstractTree;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFolder", "()Lcom/intellij/database/view/structure/forest/DvFolder;", "update", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "drop", "", "getTransferringNodes", "", "getSelection", "", "unwrapNode", "o", "", "equals", "other", "that", "hashCode", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvFolderDropTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvFolderDropTarget.kt\ncom/intellij/database/view/DvFolderDropTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n1#2:105\n1#2:121\n30#3,2:106\n774#4:108\n865#4,2:109\n11879#5,9:111\n13805#5:120\n13806#5:122\n11888#5:123\n*S KotlinDebug\n*F\n+ 1 DvFolderDropTarget.kt\ncom/intellij/database/view/DvFolderDropTarget\n*L\n69#1:121\n50#1:106,2\n61#1:108\n61#1:109,2\n69#1:111,9\n69#1:120\n69#1:122\n69#1:123\n*E\n"})
public final class DvFolderDropTarget
implements DnDTarget {
    @NotNull
    private final Project project;
    @NotNull
    private final DvFolder folder;
    @NotNull
    private final transient JTree jTree;
    @NotNull
    private final transient AbstractTree<BasicNode> abstractTree;

    public DvFolderDropTarget(@NotNull Project project, @NotNull DvFolder folder, @NotNull JTree jTree, @NotNull AbstractTree<BasicNode> abstractTree) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)jTree, (String)"jTree");
        Intrinsics.checkNotNullParameter(abstractTree, (String)"abstractTree");
        this.project = project;
        this.folder = folder;
        this.jTree = jTree;
        this.abstractTree = abstractTree;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DvFolder getFolder() {
        return this.folder;
    }

    public boolean update(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<BasicNode> nodes = this.getTransferringNodes(event);
        if (!((Collection)nodes).isEmpty()) {
            RelativeRectangle rr;
            Rectangle bounds;
            Point point = event.getPointOn((Component)this.jTree);
            int row = this.jTree.getClosestRowForLocation(point.x, point.y);
            Rectangle rectangle = bounds = this.jTree.getRowBounds(row);
            if (rectangle != null) {
                Rectangle b = rectangle;
                boolean bl = false;
                v1 = new RelativeRectangle((Component)this.jTree, b);
            } else {
                v1 = rr = null;
            }
            if (rr != null) {
                event.setDropPossible(true);
                event.setHighlighting(rr, 1);
            }
            return true;
        }
        event.setDropPossible(false);
        return false;
    }

    public void drop(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForestService forestService = (DvForestService)object;
        List<BasicNode> nodes = this.getTransferringNodes(event);
        List arms = forestService.convertVisibleNodesToArms((Collection)nodes);
        new DvMoveArmsToFolder(this.project, arms, this.folder).doIt();
    }

    /*
     * WARNING - void declaration
     */
    private final List<BasicNode> getTransferringNodes(DnDEvent event) {
        void $this$filterTo$iv$iv;
        Collection<BasicNode> selection = this.getSelection(event);
        Collection selectTops = this.abstractTree.filterTopNodes(selection);
        Iterable $this$filter$iv = selectTops;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicNode it = (BasicNode)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof DvNiceFolder || it instanceof DataSourceNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List transferringNodes = (List)destination$iv$iv;
        return transferringNodes;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<BasicNode> getSelection(DnDEvent event) {
        Collection selection;
        block4: {
            selection = CollectionsKt.emptyList();
            try {
                void $this$mapNotNullTo$iv$iv;
                Object datum = event.getTransferData(DnDEventImpl.ourDataFlavor);
                if (!(datum instanceof Object[])) break block4;
                Object[] $this$mapNotNull$iv = (Object[])datum;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    BasicNode it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void p0 = element$iv$iv;
                    boolean bl2 = false;
                    if (this.unwrapNode(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                selection = (List)destination$iv$iv;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return selection;
    }

    private final BasicNode unwrapNode(Object o) {
        BasicNode basicNode;
        block5: {
            DvFolderDropTarget dvFolderDropTarget = this;
            while (true) {
                Object object;
                DvFolderDropTarget dvFolderDropTarget2;
                Object object2;
                if ((object2 = o) == null) {
                    basicNode = null;
                    break block5;
                }
                if (object2 instanceof BasicNode) {
                    basicNode = (BasicNode)o;
                    break block5;
                }
                if (object2 instanceof AbstractDataSource) {
                    basicNode = (BasicNode)((AbstractDataSource)o).node;
                    break block5;
                }
                if (object2 instanceof DbDataSource) {
                    dvFolderDropTarget2 = dvFolderDropTarget;
                    object = ((DbDataSource)o).getDelegateDataSource();
                    dvFolderDropTarget = dvFolderDropTarget2;
                    o = object;
                    continue;
                }
                if (!(object2 instanceof DbElement)) break;
                dvFolderDropTarget2 = dvFolderDropTarget;
                object = ((DbElement)o).getDelegate();
                dvFolderDropTarget = dvFolderDropTarget2;
                o = object;
            }
            basicNode = null;
        }
        return basicNode;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DvFolderDropTarget && this.equals((DvFolderDropTarget)other);
    }

    private final boolean equals(DvFolderDropTarget that) {
        return Intrinsics.areEqual((Object)this.project, (Object)that.project) && Intrinsics.areEqual((Object)this.folder, (Object)that.folder);
    }

    public int hashCode() {
        return this.folder.hashCode();
    }
}

