/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.view.ui.CloudDatabasesTreeDataSourceNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\fj\u0002`\rJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nJ\u0019\u0010\u0013\u001a\u0013\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00010\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0010\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/ui/CloudDatabasesTreeMetadataNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "metadataId", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "myDataSources", "", "Lcom/intellij/database/view/ui/CloudDatabasesTreeDataSourceNode;", "myError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setError", "", "error", "addDataSourceNode", "dataSourceNode", "getChildren", "", "Lorg/jetbrains/annotations/Unmodifiable;", "createPresentation", "Lcom/intellij/ide/projectView/PresentationData;", "getIcon", "Ljavax/swing/Icon;", "update", "presentation", "intellij.database.impl"})
public final class CloudDatabasesTreeMetadataNode
extends AbstractTreeNode<String> {
    @NotNull
    private final String metadataId;
    @NotNull
    private final List<CloudDatabasesTreeDataSourceNode> myDataSources;
    @Nullable
    private Exception myError;

    public CloudDatabasesTreeMetadataNode(@NotNull Project project, @NotNull String metadataId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)metadataId, (String)"metadataId");
        super(project, (Object)metadataId);
        this.metadataId = metadataId;
        this.myName = this.metadataId;
        this.myDataSources = new CopyOnWriteArrayList();
    }

    public final void setError(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.myError = error;
    }

    public final void addDataSourceNode(@NotNull CloudDatabasesTreeDataSourceNode dataSourceNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataSourceNode), (String)"dataSourceNode");
        dataSourceNode.setParent(this);
        this.myDataSources.add(dataSourceNode);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return this.myDataSources;
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = super.createPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentationData, (String)"createPresentation(...)");
        PresentationData presentation = presentationData;
        this.update(presentation);
        return presentation;
    }

    private final Icon getIcon(Exception error) {
        if (error == null) {
            Icon icon = AllIcons.General.GreenCheckmark;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GreenCheckmark");
            return icon;
        }
        if (this.myDataSources.isEmpty()) {
            Icon icon = AllIcons.General.Error;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
            return icon;
        }
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        return icon;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(this.getIcon(this.myError));
        presentation.setPresentableText(this.metadataId);
        if (this.myError != null) {
            Object object = this.myError;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "";
            }
            Object text = object;
            String processedText = StringsKt.trimIndent((String)("\n        <html>\n        <head>\n        </head>\n        <body>\n        <div>" + (String)text + "</div>\n        </body>\n        </html>\n      "));
            presentation.setTooltip(processedText);
        }
    }
}

