/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.hub.ui;

import com.intellij.icons.AllIcons;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.hub.HubSpecificationModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/core/hub/ui/SwaggerHubSpecificationRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/swagger/core/hub/HubSpecificationModel;", "<init>", "()V", "mySpecificationInfoPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "myNameLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "myOwnerLabel", "Lcom/intellij/ui/components/JBLabel;", "myStatusLabel", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerHubSpecificationRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerHubSpecificationRenderer.kt\ncom/intellij/swagger/core/hub/ui/SwaggerHubSpecificationRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n13805#2,2:117\n*S KotlinDebug\n*F\n+ 1 SwaggerHubSpecificationRenderer.kt\ncom/intellij/swagger/core/hub/ui/SwaggerHubSpecificationRenderer\n*L\n105#1:117,2\n*E\n"})
public final class SwaggerHubSpecificationRenderer
implements ListCellRenderer<HubSpecificationModel> {
    @NotNull
    private final BorderLayoutPanel mySpecificationInfoPanel = new BorderLayoutPanel();
    @NotNull
    private final SimpleColoredComponent myNameLabel = new SimpleColoredComponent();
    @NotNull
    private final JBLabel myOwnerLabel = new JBLabel();
    @NotNull
    private final JBLabel myStatusLabel = new JBLabel();

    public SwaggerHubSpecificationRenderer() {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$_init__u24lambda_u240 = borderLayoutPanel = this.mySpecificationInfoPanel;
        boolean bl = false;
        $this$_init__u24lambda_u240.addToCenter((Component)this.myNameLabel);
        $this$_init__u24lambda_u240.addToBottom((Component)this.myOwnerLabel);
        $this$_init__u24lambda_u240.addToRight((Component)this.myStatusLabel);
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@Nullable JList<? extends HubSpecificationModel> list, @Nullable HubSpecificationModel value, int index, boolean isSelected, boolean cellHasFocus) {
        Object object;
        String string;
        String string2;
        if (value == null) {
            return (Component)this.mySpecificationInfoPanel;
        }
        Boolean bl = value.getPrivate();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            string2 = SwaggerBundle.message("settings.remote.specification.private", new Object[0]);
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string2 = SwaggerBundle.message("settings.remote.specification.public", new Object[0]);
        } else if (bl == null) {
            string2 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String isPrivateStatus = string2;
        Boolean bl2 = value.getPublished();
        if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
            string = SwaggerBundle.message("settings.remote.specification.published", new Object[0]);
        } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
            string = SwaggerBundle.message("settings.remote.specification.unpublished", new Object[0]);
        } else if (bl2 == null) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String isPublishedStatus = string;
        Boolean $this$getListCellRendererComponent_u24lambda_u240 = bl2 = this.myStatusLabel;
        boolean bl3 = false;
        $this$getListCellRendererComponent_u24lambda_u240.setText((String)(!StringsKt.isBlank((CharSequence)isPrivateStatus) && !StringsKt.isBlank((CharSequence)isPublishedStatus) ? isPrivateStatus + " | " + isPublishedStatus : (!StringsKt.isBlank((CharSequence)isPrivateStatus) ? isPrivateStatus : isPublishedStatus)));
        $this$getListCellRendererComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        Boolean $this$getListCellRendererComponent_u24lambda_u241 = bl2 = this.myOwnerLabel;
        boolean bl4 = false;
        CharSequence charSequence = value.getOwner();
        $this$getListCellRendererComponent_u24lambda_u241.setText((String)(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? SwaggerBundle.message("settings.remote.specification.owned.by", new Object[0]) + " " + value.getOwner() : ""));
        $this$getListCellRendererComponent_u24lambda_u241.setBorder((Border)JBUI.Borders.emptyLeft((int)21));
        int maxNameLength = 42;
        String shortenedStringSuffix = "...";
        if (value.getName().length() <= maxNameLength) {
            object = value.getName();
        } else {
            String string3 = value.getName().substring(0, maxNameLength - shortenedStringSuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object = string3 + shortenedStringSuffix;
        }
        String specificationName = object;
        CharSequence $this$getListCellRendererComponent_u24lambda_u242 = charSequence = this.myNameLabel;
        boolean bl5 = false;
        $this$getListCellRendererComponent_u24lambda_u242.clear();
        $this$getListCellRendererComponent_u24lambda_u242.append(specificationName);
        $this$getListCellRendererComponent_u24lambda_u242.setTransparentIconBackground(true);
        $this$getListCellRendererComponent_u24lambda_u242.setIcon(value.getSpecificationType() instanceof SwSpecificationType.SWAGGER_2 ? SwaggerCoreIcons.Swagger : AllIcons.Webreferences.Openapi);
        $this$getListCellRendererComponent_u24lambda_u242.setToolTipText(value.getName().length() <= maxNameLength && !StringsKt.isBlank((CharSequence)value.getDescription()) ? value.getDescription() : value.getName());
        Color color = UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListForeground(...)");
        Color foreground = color;
        Color color2 = UIUtil.getListBackground((boolean)isSelected, (boolean)cellHasFocus);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListBackground(...)");
        Color background = color2;
        this.mySpecificationInfoPanel.setForeground(foreground);
        this.mySpecificationInfoPanel.setBackground(background);
        this.mySpecificationInfoPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        Component[] componentArray = this.mySpecificationInfoPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl6 = false;
            it.setForeground(foreground);
            it.setBackground(background);
        }
        if (!cellHasFocus) {
            this.myOwnerLabel.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
            this.myStatusLabel.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
        }
        return (Component)this.mySpecificationInfoPanel;
    }
}

