/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingModel;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestContextUtilImpl
extends SpringTestContextUtil {
    public static final String CONTEXT_CONFIGURATION_SUFFIX = "ContextConfiguration";

    public boolean isTestContextConfigurationClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(0);
        }
        if (psiClass.isAnnotationType() || psiClass.isEnum()) {
            return false;
        }
        PsiFile containingFile = psiClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        if (!projectFileIndex.isInTestSourceContent(virtualFile)) {
            return false;
        }
        CommonProcessors.FindProcessor<PsiClass> findFirstProcessor = new CommonProcessors.FindProcessor<PsiClass>(this){

            protected boolean accept(PsiClass psiClass) {
                return SpringTestContextUtilImpl.isSpringTestContextConfiguration(psiClass);
            }
        };
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, (Processor)findFirstProcessor);
        return findFirstProcessor.isFound();
    }

    public static boolean isSpringTestContextConfiguration(@NotNull PsiClass psiClass) {
        List contextConfigurations;
        if (psiClass == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(1);
        }
        return !(contextConfigurations = ContainerUtil.filter((Collection)SemService.getSemService((Project)psiClass.getProject()).getSemElements(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass), configuration -> configuration.isValidContextConfiguration())).isEmpty() || JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META}) != null;
    }

    @NotNull
    public CommonSpringModel getSpringTestingModel(@NotNull PsiClass testClass) {
        Module module;
        if (testClass == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(2);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)testClass)) == null ? SpringModel.UNKNOWN : new SpringTestingModel(testClass, module);
    }

    public void discoverConfigFiles(@NotNull ContextConfiguration contextConfiguration, @NotNull Set<XmlFile> appContexts, @NotNull Set<PsiClass> configurationContexts, PsiClass ... contexts) {
        if (contextConfiguration == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(3);
        }
        if (appContexts == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(4);
        }
        if (configurationContexts == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(5);
        }
        List configurationClasses = contextConfiguration.getConfigurationClasses();
        if (!contextConfiguration.hasLocationsAttribute() && !contextConfiguration.hasValueAttribute() && configurationClasses.isEmpty()) {
            XmlFile xmlFile = SpringTestContextUtilImpl.getDefaultLocation(contextConfiguration);
            if (xmlFile != null && SpringDomUtils.isSpringXml((XmlFile)xmlFile)) {
                appContexts.add(xmlFile);
            }
        } else {
            for (XmlFile xmlFile : contextConfiguration.getLocations(contexts)) {
                if (!SpringDomUtils.isSpringXml((XmlFile)xmlFile)) continue;
                appContexts.add(xmlFile);
            }
            configurationContexts.addAll(configurationClasses);
        }
    }

    @Nullable
    static XmlFile getDefaultLocation(@NotNull ContextConfiguration contextConfiguration) {
        if (contextConfiguration == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(6);
        }
        if (!SpringTestContextUtilImpl.isAnnotationConfigLoader(contextConfiguration)) {
            PsiClass psiClass = contextConfiguration.getPsiElement();
            String defaultAppContextName = SpringTestContextUtilImpl.getDefaultAppContextName(contextConfiguration);
            PsiDirectory containingDirectory = psiClass.getContainingFile().getContainingDirectory();
            if (containingDirectory != null) {
                PsiFile file = containingDirectory.findFile(defaultAppContextName);
                if (file instanceof XmlFile) {
                    return (XmlFile)file;
                }
                PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
                if (psiPackage != null) {
                    for (PsiDirectory psiDirectory : psiPackage.getDirectories()) {
                        file = psiDirectory.findFile(defaultAppContextName);
                        if (!(file instanceof XmlFile)) continue;
                        return (XmlFile)file;
                    }
                }
            }
        }
        return null;
    }

    static String getDefaultAppContextName(@NotNull ContextConfiguration contextConfiguration) {
        if (contextConfiguration == null) {
            SpringTestContextUtilImpl.$$$reportNull$$$0(7);
        }
        String suffix = "-context.xml";
        return contextConfiguration.getPsiElement().getName() + "-context.xml";
    }

    static boolean isGenericXmlContextLoader(ContextConfiguration contextConfiguration) {
        return SpringTestContextUtilImpl.isConfigClassLoader(contextConfiguration, "org.springframework.test.context.support.GenericXmlContextLoader");
    }

    static boolean isAnnotationConfigLoader(ContextConfiguration contextConfiguration) {
        return SpringTestContextUtilImpl.isConfigClassLoader(contextConfiguration, "org.springframework.test.context.support.AnnotationConfigContextLoader");
    }

    private static boolean isConfigClassLoader(ContextConfiguration contextConfiguration, String className) {
        PsiClass psiClass = contextConfiguration.getLoaderClass();
        if (psiClass == null) {
            return false;
        }
        return className.equals(psiClass.getQualifiedName()) || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)className);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appContexts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationContexts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestContextConfigurationClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringTestContextConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringTestingModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "discoverConfigFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultAppContextName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

