/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.PatternUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextExcludeRegexpFilter
extends SpringContextFilter.ExcludeExpression {
    public SpringContextExcludeRegexpFilter(@Nullable String expression) {
        super(expression);
    }

    public boolean exclude(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringContextExcludeRegexpFilter.$$$reportNull$$$0(0);
        }
        String expression = this.getExpression();
        String fqn = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (!StringUtil.isEmptyOrSpaces((String)expression) && !StringUtil.isEmptyOrSpaces((String)fqn)) {
            try {
                return Pattern.matches(expression, fqn) || Pattern.matches(PatternUtil.convertToRegex((String)expression), fqn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/filters/SpringContextExcludeRegexpFilter", "exclude"));
    }
}

