/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.microservices.jvm.beans.BeansViewOpener;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.toolWindow.SpringToolWindowService;
import com.intellij.spring.toolWindow.SpringToolWindowServiceKt;
import org.jetbrains.annotations.NotNull;

public class SpringBeansViewSelectInTarget
implements SelectInTarget {
    public String toString() {
        return SpringBundle.message("spring", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            SpringBeansViewSelectInTarget.$$$reportNull$$$0(0);
        }
        return SpringLibraryUtil.hasSpringLibrary((Project)project);
    }

    public String getToolWindowId() {
        return "Beans";
    }

    public float getWeight() {
        return 3.0f;
    }

    public boolean canSelect(SelectInContext context) {
        Project project = context.getProject();
        if (DumbService.isDumb((Project)project) || !SpringLibraryUtil.hasSpringLibrary((Project)project) || !BeansViewOpener.isAvailable((Project)project)) {
            return false;
        }
        Object selector = context.getSelectorInFile();
        if (!(selector instanceof PsiElement)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)selector;
        if (ModuleUtilCore.findModuleForFile((VirtualFile)context.getVirtualFile(), (Project)context.getProject()) == null) {
            return false;
        }
        return SpringToolWindowServiceKt.getPointer(psiElement) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        SpringToolWindowService.getInstance(context.getProject()).selectIn(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/SpringBeansViewSelectInTarget", "isAvailable"));
    }
}

