addClickListener()

function addClickListener() {
  if (!document || !document.body || window.isListenerSet === true) return
  document.body.addEventListener('click', e => {
    const eventTarget = e.target || e.srcElement;

    for (let element = eventTarget; element; element = element.parentNode) {
      const className = element.className
      // https://developer.mozilla.org/en-US/docs/Web/API/Element/className className mught be either String or SVGAnimatedString 0_o
      if (!(typeof className === 'string' || className instanceof String)) continue;

      const objectCoordinates = processEndpoint(element, className) || processModel(element, className);
      if (objectCoordinates) {
        /*IntelliJ Swagger UI*/
        return;
      }
    }
  });
  window.isListenerSet = true
}