// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve \
// RUN: -disable-O0-optnone \
// RUN:  -emit-llvm -o - %s | opt -S -passes=sroa | FileCheck %s

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>
#include <stddef.h>

// CHECK-LABEL: @subscript_int16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 8 x i16> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i16 [[VECEXT]]
//
int16_t subscript_int16(svint16_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_uint16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 8 x i16> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i16 [[VECEXT]]
//
uint16_t subscript_uint16(svuint16_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_int32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 4 x i32> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i32 [[VECEXT]]
//
int32_t subscript_int32(svint32_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_uint32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 4 x i32> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i32 [[VECEXT]]
//
uint32_t subscript_uint32(svuint32_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_int64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 2 x i64> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i64 [[VECEXT]]
//
int64_t subscript_int64(svint64_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_uint64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 2 x i64> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret i64 [[VECEXT]]
//
uint64_t subscript_uint64(svuint64_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_float16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 8 x half> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret half [[VECEXT]]
//
__fp16 subscript_float16(svfloat16_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_float32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 4 x float> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret float [[VECEXT]]
//
float subscript_float32(svfloat32_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_float64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 2 x double> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    ret double [[VECEXT]]
//
double subscript_float64(svfloat64_t a, size_t b) {
  return a[b];
}

// CHECK-LABEL: @subscript_write_float32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECINS:%.*]] = insertelement <vscale x 4 x float> [[A:%.*]], float 1.000000e+00, i64 [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x float> [[VECINS]]
//
svfloat32_t subscript_write_float32(svfloat32_t a, size_t b) {
  a[b] = 1.0f;
  return a;
}

// CHECK-LABEL: @subscript_read_write_float32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECEXT:%.*]] = extractelement <vscale x 4 x float> [[A:%.*]], i64 [[B:%.*]]
// CHECK-NEXT:    [[ADD:%.*]] = fadd float [[VECEXT]], 1.000000e+00
// CHECK-NEXT:    [[VECINS:%.*]] = insertelement <vscale x 4 x float> [[A]], float [[ADD]], i64 [[B]]
// CHECK-NEXT:    ret <vscale x 4 x float> [[VECINS]]
//
svfloat32_t subscript_read_write_float32(svfloat32_t a, size_t b) {
  a[b] += 1.0f;
  return a;
}
