/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;

public class GetRollupIndexCapsAction
extends ActionType<Response> {
    public static final GetRollupIndexCapsAction INSTANCE = new GetRollupIndexCapsAction();
    public static final String NAME = "indices:data/read/xpack/rollup/get/index/caps";
    public static final ParseField CONFIG = new ParseField("config", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);
    private static final ParseField INDICES_OPTIONS = new ParseField("indices_options", new String[0]);

    private GetRollupIndexCapsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements Writeable,
    ToXContentObject {
        private Map<String, RollableIndexCaps> jobs = Collections.emptyMap();

        public Response() {
        }

        public Response(Map<String, RollableIndexCaps> jobs) {
            this.jobs = Objects.requireNonNull(jobs);
        }

        public Map<String, RollableIndexCaps> getJobs() {
            return this.jobs;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.jobs, StreamOutput::writeWriteable);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (Map.Entry<String, RollableIndexCaps> entry : this.jobs.entrySet()) {
                entry.getValue().toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobs, other.jobs);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest.Replaceable,
    ToXContentFragment {
        private String[] indices;
        private IndicesOptions options;

        public Request(String[] indices) {
            this(indices, IndicesOptions.STRICT_EXPAND_OPEN_FORBID_CLOSED);
        }

        public Request(String[] indices, IndicesOptions options) {
            this.indices = indices;
            this.options = options;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
            this.options = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public IndicesOptions indicesOptions() {
            return this.options;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesRequest indices(String ... indices) {
            Objects.requireNonNull(indices, "indices must not be null");
            for (String index : indices) {
                Objects.requireNonNull(index, "index must not be null");
            }
            this.indices = indices;
            return this;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            this.options.writeIndicesOptions(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.array(RollupField.ID.getPreferredName(), this.indices);
            builder.field(INDICES_OPTIONS.getPreferredName(), (ToXContent)this.options);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.options);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Arrays.equals(this.indices, other.indices) && Objects.equals(this.options, other.options);
        }
    }
}

