/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLast;

public final class MvLastBytesRefEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvLastBytesRefEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvLast";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef valueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                BytesRef result = MvLast.process(v, first, end, valueScratch);
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefVector.Builder builder = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef valueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                BytesRef result = MvLast.process(v, first, end, valueScratch);
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build().asBlock();
            return bytesRefBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvLastBytesRefEvaluator get(DriverContext context) {
            return new MvLastBytesRefEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvLast[field=" + String.valueOf(this.field) + "]";
        }
    }
}

