/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;

public final class SplitSingleByteEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final byte delim;
    private final BytesRef scratch;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SplitSingleByteEvaluator(Source source, EvalOperator.ExpressionEvaluator str, byte delim, BytesRef scratch, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.delim = delim;
        this.scratch = scratch;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefVector strVector = strBlock.asVector();
            if (strVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), strBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), strVector);
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                Split.process(result, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), this.delim, this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                Split.process(result, strVector.getBytesRef(p, strScratch), this.delim, this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "SplitSingleByteEvaluator[str=" + String.valueOf(this.str) + ", delim=" + this.delim + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.str);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final byte delim;
        private final Function<DriverContext, BytesRef> scratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, byte delim, Function<DriverContext, BytesRef> scratch) {
            this.source = source;
            this.str = str;
            this.delim = delim;
            this.scratch = scratch;
        }

        public SplitSingleByteEvaluator get(DriverContext context) {
            return new SplitSingleByteEvaluator(this.source, this.str.get(context), this.delim, this.scratch.apply(context), context);
        }

        public String toString() {
            return "SplitSingleByteEvaluator[str=" + String.valueOf(this.str) + ", delim=" + this.delim + "]";
        }
    }
}

