/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xcontent.XContentType;

public class AuditUtil {
    public static final String AUDIT_REQUEST_ID = "_xpack_audit_request_id";

    public static String restRequestContent(RestRequest request) {
        if (request.hasContent()) {
            ReleasableBytesReference content = request.content();
            try {
                return XContentHelper.convertToJson((BytesReference)content, (boolean)false, (boolean)false, (XContentType)request.getXContentType());
            }
            catch (IOException ioe) {
                return "Invalid Format: " + content.utf8ToString();
            }
        }
        return "";
    }

    public static Set<String> indices(TransportMessage message) {
        if (message instanceof IndicesRequest) {
            return AuditUtil.arrayToSetOrNull(((IndicesRequest)message).indices());
        }
        return null;
    }

    private static Set<String> arrayToSetOrNull(String[] indices) {
        return indices == null ? null : new HashSet<String>(Arrays.asList(indices));
    }

    public static String generateRequestId(ThreadContext threadContext) {
        return AuditUtil.generateRequestId(threadContext, true);
    }

    public static String getOrGenerateRequestId(ThreadContext threadContext) {
        String requestId = AuditUtil.extractRequestId(threadContext);
        if (Strings.isEmpty((CharSequence)requestId)) {
            return AuditUtil.generateRequestId(threadContext, false);
        }
        return requestId;
    }

    private static String generateRequestId(ThreadContext threadContext, boolean checkExisting) {
        String existing;
        if (checkExisting && (existing = AuditUtil.extractRequestId(threadContext)) != null) {
            throw new IllegalStateException("Cannot generate a new audit request id - existing id [" + existing + "] already registered");
        }
        String requestId = UUIDs.randomBase64UUID((Random)Randomness.get());
        threadContext.putHeader(AUDIT_REQUEST_ID, requestId);
        return requestId;
    }

    public static String extractRequestId(ThreadContext threadContext) {
        return threadContext.getHeader(AUDIT_REQUEST_ID);
    }
}

