/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.azureopenai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureopenai.AzureOpenAiActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.AzureOpenAiCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.AzureOpenAiEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionModel;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;

public class AzureOpenAiActionCreator
implements AzureOpenAiActionVisitor {
    private static final String COMPLETION_ERROR_PREFIX = "Azure OpenAI completion";
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AzureOpenAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AzureOpenAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        AzureOpenAiEmbeddingsModel overriddenModel = AzureOpenAiEmbeddingsModel.of(model, taskSettings);
        AzureOpenAiEmbeddingsRequestManager requestCreator = new AzureOpenAiEmbeddingsRequestManager(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Azure OpenAI embeddings");
        return new SenderExecutableAction(this.sender, requestCreator, errorMessage);
    }

    @Override
    public ExecutableAction create(AzureOpenAiCompletionModel model, Map<String, Object> taskSettings) {
        AzureOpenAiCompletionModel overriddenModel = AzureOpenAiCompletionModel.of(model, taskSettings);
        AzureOpenAiCompletionRequestManager requestCreator = new AzureOpenAiCompletionRequestManager(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(COMPLETION_ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, requestCreator, errorMessage, COMPLETION_ERROR_PREFIX);
    }
}

