/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureaistudio.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AzureAiStudioModel
extends Model {
    protected String target;
    protected URI uri;
    protected AzureAiStudioProvider provider;
    protected AzureAiStudioEndpointType endpointType;
    protected RateLimitSettings rateLimitSettings;

    public AzureAiStudioModel(AzureAiStudioModel model, TaskSettings taskSettings, RateLimitSettings rateLimitSettings) {
        super((Model)model, taskSettings);
        this.rateLimitSettings = Objects.requireNonNull(rateLimitSettings);
        this.setPropertiesFromServiceSettings((AzureAiStudioServiceSettings)model.getServiceSettings());
    }

    public AzureAiStudioModel(AzureAiStudioModel model, AzureAiStudioServiceSettings serviceSettings) {
        super((Model)model, (ServiceSettings)serviceSettings);
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    protected AzureAiStudioModel(ModelConfigurations modelConfigurations, ModelSecrets modelSecrets) {
        super(modelConfigurations, modelSecrets);
        this.setPropertiesFromServiceSettings((AzureAiStudioServiceSettings)modelConfigurations.getServiceSettings());
    }

    private void setPropertiesFromServiceSettings(AzureAiStudioServiceSettings serviceSettings) {
        this.target = serviceSettings.target;
        this.provider = serviceSettings.provider();
        this.endpointType = serviceSettings.endpointType();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
        try {
            this.uri = this.getEndpointUri();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract URI getEndpointUri() throws URISyntaxException;

    public String target() {
        return this.target;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public AzureAiStudioProvider provider() {
        return this.provider;
    }

    public AzureAiStudioEndpointType endpointType() {
        return this.endpointType;
    }

    public URI uri() {
        return this.uri;
    }

    public void setURI(String newUri) {
        try {
            this.uri = new URI(newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public abstract ExecutableAction accept(AzureAiStudioActionVisitor var1, Map<String, Object> var2);
}

