/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public abstract class ElasticsearchInternalModel
extends Model {
    protected ElasticsearchInternalServiceSettings internalServiceSettings;

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, ChunkingSettings chunkingSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, chunkingSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, TaskSettings taskSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, taskSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, TaskSettings taskSettings, ChunkingSettings chunkingSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, taskSettings, chunkingSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public StartTrainedModelDeploymentAction.Request getStartTrainedModelDeploymentActionRequest(TimeValue timeout) {
        StartTrainedModelDeploymentAction.Request startRequest = new StartTrainedModelDeploymentAction.Request(this.internalServiceSettings.modelId(), this.getInferenceEntityId());
        startRequest.setNumberOfAllocations(this.internalServiceSettings.getNumAllocations());
        startRequest.setThreadsPerAllocation(this.internalServiceSettings.getNumThreads());
        startRequest.setAdaptiveAllocationsSettings(this.internalServiceSettings.getAdaptiveAllocationsSettings());
        startRequest.setTimeout(timeout);
        startRequest.setWaitForState(AllocationStatus.State.STARTED);
        return startRequest;
    }

    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException(ElasticsearchInternalModel.this.modelNotFoundErrorMessage(ElasticsearchInternalModel.this.internalServiceSettings.modelId()), new Object[0]));
                    return;
                }
                if (cause instanceof ElasticsearchStatusException) {
                    ElasticsearchStatusException statusException = (ElasticsearchStatusException)cause;
                    if (statusException.status() == RestStatus.CONFLICT && statusException.getRootCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)Boolean.TRUE);
                    }
                    return;
                }
                listener.onFailure(e);
            }
        };
    }

    protected String modelNotFoundErrorMessage(String modelId) {
        return "Could not deploy model [" + modelId + "] as the model cannot be found.";
    }

    public boolean usesExistingDeployment() {
        return this.internalServiceSettings.getDeploymentId() != null;
    }

    public ElasticsearchInternalServiceSettings getServiceSettings() {
        return (ElasticsearchInternalServiceSettings)super.getServiceSettings();
    }

    public void updateNumAllocations(Integer numAllocations) {
        this.internalServiceSettings.setNumAllocations(numAllocations);
    }

    public String toString() {
        return Strings.toString((ToXContent)this.getConfigurations());
    }

    public String mlNodeDeploymentId() {
        return this.internalServiceSettings.getDeploymentId() == null ? this.getInferenceEntityId() : this.internalServiceSettings.getDeploymentId();
    }
}

