/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.TransportSearchableSnapshotCacheStoresAction;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheInfoService;

public class SearchableSnapshotAllocator
implements ExistingShardsAllocator {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotAllocator.class);
    private static final ActionListener<Void> REROUTE_LISTENER = new ActionListener<Void>(){

        public void onResponse(Void ignored) {
            logger.trace("reroute succeeded after loading snapshot cache information");
        }

        public void onFailure(Exception e) {
            logger.warn("reroute failed", (Throwable)e);
        }
    };
    public static final String ALLOCATOR_NAME = "searchable_snapshot_allocator";
    private final ConcurrentMap<ShardId, AsyncCacheStatusFetch> asyncFetchStore = ConcurrentCollections.newConcurrentMap();
    private final Client client;
    private final RerouteService rerouteService;
    private final FrozenCacheInfoService frozenCacheInfoService;

    public SearchableSnapshotAllocator(Client client, RerouteService rerouteService, FrozenCacheInfoService frozenCacheInfoService) {
        this.client = client;
        this.rerouteService = rerouteService;
        this.frozenCacheInfoService = frozenCacheInfoService;
    }

    public void beforeAllocation(RoutingAllocation allocation) {
        boolean hasPartialIndices = false;
        for (IndexMetadata indexMetadata : allocation.metadata()) {
            if (!indexMetadata.isPartialSearchableSnapshot()) continue;
            hasPartialIndices = true;
            break;
        }
        if (hasPartialIndices) {
            this.frozenCacheInfoService.updateNodes(this.client, allocation.routingNodes().stream().map(RoutingNode::node).collect(Collectors.toSet()), this.rerouteService);
        } else {
            this.frozenCacheInfoService.updateNodes(this.client, Collections.emptySet(), this.rerouteService);
        }
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation, Predicate<ShardRouting> isRelevantShardPredicate) {
    }

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision;
        String recoveryUuid;
        if (shardRouting.primary() && (recoveryUuid = SearchableSnapshotAllocator.getRecoverySourceRestoreUuid(shardRouting, allocation)) != null) {
            Settings indexSettings = allocation.metadata().index(shardRouting.index()).getSettings();
            IndexId indexId = new IndexId((String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings));
            SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings));
            String repositoryUuid = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(indexSettings);
            String repositoryName = !Strings.hasLength((String)repositoryUuid) ? (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexSettings) : (String)RepositoriesMetadata.get((ClusterState)allocation.getClusterState()).repositories().stream().filter(r -> repositoryUuid.equals(r.uuid())).map(RepositoryMetadata::name).findFirst().orElse(null);
            if (repositoryName == null) {
                unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.DECIDERS_NO, allocation.changes());
                return;
            }
            Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
            IndexVersion version = shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT ? ((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource()).version() : IndexVersion.current();
            RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(recoveryUuid, snapshot, version, indexId);
            if (!shardRouting.recoverySource().equals((Object)recoverySource)) {
                shardRouting = unassignedAllocationHandler.updateUnassigned(shardRouting.unassignedInfo(), (RecoverySource)recoverySource, allocation.changes());
            }
        }
        if ((allocateUnassignedDecision = this.decideAllocation(allocation, shardRouting)).isDecisionTaken()) {
            if (allocateUnassignedDecision.getAllocationDecision() == AllocationDecision.YES) {
                unassignedAllocationHandler.initialize(allocateUnassignedDecision.getTargetNode().getId(), allocateUnassignedDecision.getAllocationId(), ExpectedShardSizeEstimator.getExpectedShardSize((ShardRouting)shardRouting, (long)-1L, (RoutingAllocation)allocation), allocation.changes());
            } else {
                unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
            }
        }
    }

    @Nullable
    private static String getRecoverySourceRestoreUuid(ShardRouting shardRouting, RoutingAllocation allocation) {
        switch (shardRouting.recoverySource().getType()) {
            case EXISTING_STORE: 
            case EMPTY_STORE: {
                return "_no_api_";
            }
            case SNAPSHOT: {
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
                if (recoverySource.restoreUUID().equals("_no_api_")) {
                    return "_no_api_";
                }
                RestoreInProgress.Entry entry = RestoreInProgress.get((ClusterState)allocation.getClusterState()).get(recoverySource.restoreUUID());
                if (entry == null) {
                    return "_no_api_";
                }
                RestoreInProgress.ShardRestoreStatus shardRestoreStatus = (RestoreInProgress.ShardRestoreStatus)entry.shards().get(shardRouting.shardId());
                if (shardRestoreStatus == null || shardRestoreStatus.state().completed()) {
                    return "_no_api_";
                }
                return recoverySource.restoreUUID();
            }
        }
        return null;
    }

    private AllocateUnassignedDecision decideAllocation(RoutingAllocation allocation, ShardRouting shardRouting) {
        assert (shardRouting.unassigned());
        assert (((String)ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings())).equals(ALLOCATOR_NAME));
        if (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && allocation.snapshotShardSizeInfo().getShardSize(shardRouting) == null) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        if (((Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(allocation.metadata().index(shardRouting.index()).getSettings())).booleanValue() && this.frozenCacheInfoService.isFetching()) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        boolean explain = allocation.debugDecision();
        ReplicaShardAllocator.PerNodeAllocationResult result = ReplicaShardAllocator.canBeAllocatedToAtLeastOneNode((ShardRouting)shardRouting, (RoutingAllocation)allocation);
        Decision allocateDecision = result.decision();
        if (!(allocateDecision.type() == Decision.Type.YES || explain && this.asyncFetchStore.get(shardRouting.shardId()) != null)) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)shardRouting);
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.fromDecision((Decision.Type)allocateDecision.type()), (List)result.nodes());
        }
        AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> fetchedCacheData = this.fetchData(shardRouting, allocation);
        if (!fetchedCacheData.hasData()) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        MatchingNodes matchingNodes = SearchableSnapshotAllocator.findMatchingNodes(shardRouting, allocation, fetchedCacheData, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        List nodeDecisions = ReplicaShardAllocator.augmentExplanationsWithStoreInfo((List)result.nodes(), matchingNodes.nodeDecisions);
        if (allocateDecision.type() != Decision.Type.YES) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.fromDecision((Decision.Type)allocateDecision.type()), (List)nodeDecisions);
        }
        if (matchingNodes.nodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.nodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocate(shardRouting, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent cache", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)shardRouting, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle((List)nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its persistent cache", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)shardRouting, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes((DiscoveryNode)nodeWithHighestMatch.node(), null, (List)nodeDecisions, (boolean)true);
        }
        if (SearchableSnapshotAllocator.isDelayedDueToNodeRestart(allocation, shardRouting)) {
            return ReplicaShardAllocator.delayedDecision((ShardRouting)shardRouting, (RoutingAllocation)allocation, (Logger)logger, (List)nodeDecisions);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    private static boolean isDelayedDueToNodeRestart(RoutingAllocation allocation, ShardRouting shardRouting) {
        String lastAllocatedNodeId;
        if (shardRouting.unassignedInfo().delayed() && (lastAllocatedNodeId = shardRouting.unassignedInfo().lastAllocatedNodeId()) != null) {
            return allocation.metadata().nodeShutdowns().contains(lastAllocatedNodeId, SingleNodeShutdownMetadata.Type.RESTART);
        }
        return false;
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        return this.decideAllocation(routingAllocation, shardRouting);
    }

    public void cleanCaches() {
        this.asyncFetchStore.clear();
        this.frozenCacheInfoService.clear();
    }

    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        for (ShardRouting startedShard : startedShards) {
            this.asyncFetchStore.remove(startedShard.shardId());
        }
    }

    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        for (FailedShard failedShard : failedShards) {
            this.asyncFetchStore.remove(failedShard.routingEntry().shardId());
        }
    }

    public int getNumberOfInFlightFetches() {
        int count = 0;
        for (AsyncCacheStatusFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.numberOfInFlightFetches();
        }
        return count;
    }

    private AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        DiscoveryNodes nodes;
        ShardId shardId = shard.shardId();
        Settings indexSettings = allocation.metadata().index(shard.index()).getSettings();
        if (((Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(indexSettings)).booleanValue()) {
            return new AsyncShardFetch.FetchResult(shardId, Collections.emptyMap(), Collections.emptySet());
        }
        SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings));
        final AsyncCacheStatusFetch asyncFetch = this.asyncFetchStore.computeIfAbsent(shardId, sid -> new AsyncCacheStatusFetch());
        final DiscoveryNode[] dataNodes = asyncFetch.addFetches((DiscoveryNode[])(nodes = allocation.nodes()).getDataNodes().values().toArray(DiscoveryNode[]::new));
        if (dataNodes.length > 0) {
            this.client.execute(TransportSearchableSnapshotCacheStoresAction.TYPE, (ActionRequest)new TransportSearchableSnapshotCacheStoresAction.Request(snapshotId, shardId, dataNodes), ActionListener.runAfter((ActionListener)new ActionListener<TransportSearchableSnapshotCacheStoresAction.NodesCacheFilesMetadata>(this){

                public void onResponse(TransportSearchableSnapshotCacheStoresAction.NodesCacheFilesMetadata nodesCacheFilesMetadata) {
                    Map res = Maps.newMapWithExpectedSize((int)nodesCacheFilesMetadata.getNodesMap().size());
                    for (Map.Entry entry : nodesCacheFilesMetadata.getNodesMap().entrySet()) {
                        res.put(nodes.get((String)entry.getKey()), (TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata)((Object)entry.getValue()));
                    }
                    for (FailedNodeException failedNodeException : nodesCacheFilesMetadata.failures()) {
                        DiscoveryNode dataNode = nodes.get(failedNodeException.nodeId());
                        logger.warn("Failed fetching cache size from datanode", (Throwable)failedNodeException);
                        res.put(dataNode, new TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata(dataNode, 0L));
                    }
                    asyncFetch.addData(res);
                }

                public void onFailure(Exception e) {
                    logger.warn("Failure when trying to fetch existing cache sizes", (Throwable)e);
                    Map res = Maps.newMapWithExpectedSize((int)dataNodes.length);
                    for (DiscoveryNode dataNode : dataNodes) {
                        res.put(dataNode, new TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata(dataNode, 0L));
                    }
                    asyncFetch.addData(res);
                }
            }, () -> {
                if (asyncFetch.data() != null) {
                    this.rerouteService.reroute("async_shard_cache_fetch", Priority.HIGH, REROUTE_LISTENER);
                }
            }));
        }
        return new AsyncShardFetch.FetchResult(shardId, asyncFetch.data(), Collections.emptySet());
    }

    private static MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data, boolean explain) {
        HashMap<DiscoveryNode, Long> matchingNodesCacheSizes = new HashMap<DiscoveryNode, Long>();
        HashMap<String, NodeAllocationResult> nodeDecisionsDebug = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (Map.Entry nodeStoreEntry : data.getData().entrySet()) {
            RoutingNode node;
            DiscoveryNode discoNode = (DiscoveryNode)nodeStoreEntry.getKey();
            TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata nodeCacheFilesMetadata = (TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata)((Object)nodeStoreEntry.getValue());
            if (nodeCacheFilesMetadata.bytesCached() == 0L || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            Long matchingBytes = null;
            if (explain) {
                matchingBytes = nodeCacheFilesMetadata.bytesCached();
                NodeAllocationResult.ShardStoreInfo shardStoreInfo = new NodeAllocationResult.ShardStoreInfo(matchingBytes.longValue());
                nodeDecisionsDebug.put(node.nodeId(), new NodeAllocationResult(discoNode, shardStoreInfo, decision));
            }
            if (decision.type() == Decision.Type.NO) continue;
            if (matchingBytes == null) {
                matchingBytes = nodeCacheFilesMetadata.bytesCached();
            }
            matchingNodesCacheSizes.put(discoNode, matchingBytes);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable cache data", (Object)shard, (Object)discoNode.getName(), (Object)ByteSizeValue.ofBytes((long)matchingBytes), (Object)matchingBytes);
        }
        return MatchingNodes.create(matchingNodesCacheSizes, nodeDecisionsDebug);
    }

    private record MatchingNodes(@Nullable Map<String, NodeAllocationResult> nodeDecisions, @Nullable DiscoveryNode nodeWithHighestMatch) {
        private static MatchingNodes create(Map<DiscoveryNode, Long> matchingNodes, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
            return new MatchingNodes(nodeDecisions, MatchingNodes.getNodeWithHighestMatch(matchingNodes));
        }

        @Nullable
        private static DiscoveryNode getNodeWithHighestMatch(Map<DiscoveryNode, Long> matchingNodes) {
            return matchingNodes.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        }
    }

    private static final class AsyncCacheStatusFetch {
        private final Set<DiscoveryNode> fetchingDataNodes = new HashSet<DiscoveryNode>();
        private final Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data = new HashMap<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata>();

        AsyncCacheStatusFetch() {
        }

        synchronized DiscoveryNode[] addFetches(DiscoveryNode[] nodes) {
            ArrayList<DiscoveryNode> nodesToFetch = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode node : nodes) {
                if (this.data.containsKey(node) || !this.fetchingDataNodes.add(node)) continue;
                nodesToFetch.add(node);
            }
            return nodesToFetch.toArray(new DiscoveryNode[0]);
        }

        synchronized void addData(Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> newData) {
            this.data.putAll(newData);
            this.fetchingDataNodes.removeAll(newData.keySet());
        }

        @Nullable
        synchronized Map<DiscoveryNode, TransportSearchableSnapshotCacheStoresAction.NodeCacheFilesMetadata> data() {
            return this.fetchingDataNodes.size() > 0 ? null : Map.copyOf(this.data);
        }

        synchronized int numberOfInFlightFetches() {
            return this.fetchingDataNodes.size();
        }
    }
}

