/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class Page
implements Writeable {
    private final Block[] blocks;
    private final int positionCount;
    private boolean blocksReleased = false;

    public Page(Block ... blocks) {
        this(true, Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        this(true, positionCount, blocks);
    }

    private Page(boolean copyBlocks, int positionCount, Block[] blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.positionCount = positionCount;
        this.blocks = copyBlocks ? (Block[])blocks.clone() : blocks;
        for (Block b : blocks) {
            assert (b.getPositionCount() == positionCount) : "expected positionCount=" + positionCount + " but was " + String.valueOf(b);
            if (!b.isReleased()) continue;
            throw new IllegalArgumentException("can't build page out of released blocks but [" + String.valueOf(b) + "] was released");
        }
    }

    private Page(Page prev, Block[] toAdd) {
        for (Block block : toAdd) {
            if (prev.positionCount == block.getPositionCount()) continue;
            throw new IllegalArgumentException("Block [" + String.valueOf(block) + "] does not have same position count: " + block.getPositionCount() + " != " + prev.positionCount);
        }
        this.positionCount = prev.positionCount;
        this.blocks = Arrays.copyOf(prev.blocks, prev.blocks.length + toAdd.length);
        System.arraycopy(toAdd, 0, this.blocks, prev.blocks.length, toAdd.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page(StreamInput in) throws IOException {
        int positionCount = in.readVInt();
        int blockPositions = in.readVInt();
        Releasable[] blocks = new Block[blockPositions];
        boolean success = false;
        try {
            for (int blockIndex = 0; blockIndex < blockPositions; ++blockIndex) {
                blocks[blockIndex] = (Block)in.readNamedWriteable(Block.class);
            }
            success = true;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
        this.positionCount = positionCount;
        this.blocks = blocks;
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }

    public <B extends Block> B getBlock(int blockIndex) {
        if (this.blocksReleased) {
            throw new IllegalStateException("can't read released page");
        }
        Block block = this.blocks[blockIndex];
        if (block.isReleased()) {
            throw new IllegalStateException("can't read released block [" + String.valueOf(block) + "]");
        }
        return (B)block;
    }

    public Page appendBlock(Block block) {
        return new Page(this, new Block[]{block});
    }

    public Page appendBlocks(Block[] toAdd) {
        return new Page(this, toAdd);
    }

    public Page appendPage(Page toAdd) {
        return this.appendBlocks(toAdd.blocks);
    }

    public int hashCode() {
        int result = Objects.hash(this.positionCount);
        for (Block block : this.blocks) {
            result = 31 * result + Objects.hashCode(block);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.positionCount == page.positionCount && (this.positionCount == 0 || Arrays.equals(this.blocks, 0, this.blocks.length, page.blocks, 0, page.blocks.length));
    }

    public String toString() {
        return "Page{blocks=" + Arrays.toString(this.blocks) + "}";
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.positionCount);
        out.writeVInt(this.getBlockCount());
        for (Block block : this.blocks) {
            out.writeNamedWriteable((NamedWriteable)block);
        }
    }

    public long ramBytesUsedByBlocks() {
        return Arrays.stream(this.blocks).mapToLong(Accountable::ramBytesUsed).sum();
    }

    public void releaseBlocks() {
        if (this.blocksReleased) {
            return;
        }
        this.blocksReleased = true;
        Releasables.closeExpectNoException((Releasable[])this.blocks);
    }

    public void allowPassingToDifferentDriver() {
        for (Block block : this.blocks) {
            block.allowPassingToDifferentDriver();
        }
    }

    public Page shallowCopy() {
        for (Block b : this.blocks) {
            b.incRef();
        }
        return new Page(this.blocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page projectBlocks(int[] blockMapping) {
        if (this.blocksReleased) {
            throw new IllegalStateException("can't read released page");
        }
        Releasable[] mapped = new Block[blockMapping.length];
        try {
            for (int b = 0; b < blockMapping.length; ++b) {
                if (blockMapping[b] >= this.blocks.length) {
                    throw new IllegalArgumentException("Cannot project block with index [" + blockMapping[b] + "] from a page with size [" + this.blocks.length + "]");
                }
                mapped[b] = this.blocks[blockMapping[b]];
                mapped[b].incRef();
            }
            Page result = new Page(false, this.getPositionCount(), (Block[])mapped);
            mapped = null;
            Page page = result;
            return page;
        }
        finally {
            if (mapped != null) {
                Releasables.close((Releasable[])mapped);
            }
        }
    }
}

