/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class FilterOperator
extends AbstractPageMappingOperator {
    private final EvalOperator.ExpressionEvaluator evaluator;

    public FilterOperator(EvalOperator.ExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        int rowCount = 0;
        int[] positions = new int[page.getPositionCount()];
        try (BooleanBlock test = (BooleanBlock)this.evaluator.eval(page);){
            if (test.areAllValuesNull()) {
                page.releaseBlocks();
                Page page2 = null;
                return page2;
            }
            for (int p = 0; p < page.getPositionCount(); ++p) {
                if (test.isNull(p) || test.getValueCount(p) != 1 || !test.getBoolean(test.getFirstValueIndex(p))) continue;
                positions[rowCount++] = p;
            }
            if (rowCount == 0) {
                page.releaseBlocks();
                Page p = null;
                return p;
            }
            if (rowCount == page.getPositionCount()) {
                Page p = page;
                return p;
            }
            positions = Arrays.copyOf(positions, rowCount);
            Releasable[] filteredBlocks = new Block[page.getBlockCount()];
            boolean success = false;
            try {
                for (int i = 0; i < page.getBlockCount(); ++i) {
                    filteredBlocks[i] = page.getBlock(i).filter(positions);
                }
                success = true;
            }
            finally {
                page.releaseBlocks();
                if (!success) {
                    Releasables.closeExpectNoException((Releasable[])filteredBlocks);
                }
            }
            Page page3 = new Page((Block[])filteredBlocks);
            return page3;
        }
    }

    @Override
    public String toString() {
        return "FilterOperator[evaluator=" + String.valueOf(this.evaluator) + "]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.evaluator, () -> super.close()});
    }

    public record FilterOperatorFactory(EvalOperator.ExpressionEvaluator.Factory evaluatorSupplier) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new FilterOperator(this.evaluatorSupplier.get(driverContext));
        }

        @Override
        public String describe() {
            return "FilterOperator[evaluator=" + String.valueOf(this.evaluatorSupplier) + "]";
        }
    }
}

