/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.transport.Transport;

abstract class SearchPhase {
    private final String name;

    protected SearchPhase(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    protected abstract void run();

    public String getName() {
        return this.name;
    }

    protected String missingShardsErrorMessage(StringBuilder missingShards) {
        return SearchPhase.makeMissingShardsError(missingShards);
    }

    protected static String makeMissingShardsError(StringBuilder missingShards) {
        return "Search rejected due to missing shards [" + String.valueOf(missingShards) + "]. Consider using `allow_partial_search_results` setting to bypass this error.";
    }

    protected void doCheckNoMissingShards(String phaseName, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts) {
        SearchPhase.doCheckNoMissingShards(phaseName, request, shardsIts, this::missingShardsErrorMessage);
    }

    protected static void doCheckNoMissingShards(String phaseName, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts, Function<StringBuilder, String> makeErrorMessage) {
        assert (request.allowPartialSearchResults() != null) : "SearchRequest missing setting for allowPartialSearchResults";
        if (!request.allowPartialSearchResults().booleanValue()) {
            StringBuilder missingShards = new StringBuilder();
            for (int index = 0; index < shardsIts.size(); ++index) {
                SearchShardIterator shardRoutings = shardsIts.get(index);
                if (shardRoutings.size() != 0) continue;
                if (!missingShards.isEmpty()) {
                    missingShards.append(", ");
                }
                missingShards.append(shardRoutings.shardId());
            }
            if (!missingShards.isEmpty()) {
                String msg = makeErrorMessage.apply(missingShards);
                throw new SearchPhaseExecutionException(phaseName, msg, null, ShardSearchFailure.EMPTY_ARRAY);
            }
        }
    }

    protected static void releaseIrrelevantSearchContext(SearchPhaseResult searchPhaseResult, AbstractSearchAsyncAction<?> context) {
        SearchPhaseResult phaseResult;
        if (searchPhaseResult == null) {
            return;
        }
        SearchPhaseResult searchPhaseResult2 = phaseResult = searchPhaseResult.queryResult() != null ? searchPhaseResult.queryResult() : searchPhaseResult.rankFeatureResult();
        if (phaseResult != null && phaseResult.hasSearchContext() && context.getRequest().scroll() == null && !context.isPartOfPointInTime(phaseResult.getContextId())) {
            try {
                context.getLogger().trace("trying to release search context [{}]", (Object)phaseResult.getContextId());
                SearchShardTarget shardTarget = phaseResult.getSearchShardTarget();
                Transport.Connection connection = context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId());
                context.sendReleaseSearchContext(phaseResult.getContextId(), connection);
            }
            catch (Exception e) {
                context.getLogger().trace("failed to release context", (Throwable)e);
            }
        }
    }
}

