/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.plugins.PluginsLoader;

class PluginsResolver {
    private final Map<Module, String> pluginNameByModule;

    private PluginsResolver(Map<Module, String> pluginNameByModule) {
        this.pluginNameByModule = pluginNameByModule;
    }

    public static PluginsResolver create(PluginsLoader pluginsLoader) {
        HashMap<Module, String> pluginNameByModule = new HashMap<Module, String>();
        pluginsLoader.pluginLayers().forEach(pluginLayer -> {
            String pluginName = pluginLayer.pluginBundle().pluginDescriptor().getName();
            if (pluginLayer.pluginModuleLayer() != null && pluginLayer.pluginModuleLayer() != ModuleLayer.boot()) {
                for (Module module : pluginLayer.pluginModuleLayer().modules()) {
                    pluginNameByModule.put(module, pluginName);
                }
            } else {
                pluginNameByModule.put(pluginLayer.pluginClassLoader().getUnnamedModule(), pluginName);
            }
        });
        return new PluginsResolver(pluginNameByModule);
    }

    public String resolveClassToPluginName(Class<?> clazz) {
        Module module = clazz.getModule();
        return this.pluginNameByModule.get(module);
    }
}

